/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.recognizer.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.recognizer.JDBCDriverURLRecognizerEngine;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.recognizer.spi.JDBCDriverComposeURLRecognizer;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.recognizer.spi.JDBCDriverURLRecognizer;

public final class P6SpyDriverRecognizer
implements JDBCDriverComposeURLRecognizer {
    public static final String DRIVER_CLASS_NAME = "com.p6spy.engine.spy.P6SpyDriver";

    @Override
    public JDBCDriverURLRecognizer getDriverURLRecognizer(String url) {
        String realUrl = this.extractRealUrl(url);
        final JDBCDriverURLRecognizer driverURLRecognizer = JDBCDriverURLRecognizerEngine.getJDBCDriverURLRecognizer(realUrl);
        return new JDBCDriverURLRecognizer(){

            @Override
            public Collection<String> getURLPrefixes() {
                return driverURLRecognizer.getURLPrefixes();
            }

            @Override
            public String getDriverClassName() {
                return P6SpyDriverRecognizer.DRIVER_CLASS_NAME;
            }

            public String getDatabaseType() {
                return driverURLRecognizer.getDatabaseType();
            }
        };
    }

    private String extractRealUrl(String url) {
        return url.replace("p6spy:", "");
    }

    public String getDatabaseType() {
        throw new ShardingSphereException("Unsupported getDatabaseType method!", new Object[0]);
    }

    @Override
    public Collection<String> getURLPrefixes() {
        return Collections.singleton("jdbc:p6spy:");
    }

    @Override
    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }
}

