/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.recognizer;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.recognizer.spi.JDBCDriverComposeURLRecognizer;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.recognizer.spi.JDBCDriverURLRecognizer;

public final class JDBCDriverURLRecognizerEngine {
    private static final Collection<JDBCDriverURLRecognizer> JDBC_DRIVER_URL_RECOGNIZERS = new LinkedList<JDBCDriverURLRecognizer>();

    public static JDBCDriverURLRecognizer getJDBCDriverURLRecognizer(String url) {
        JDBCDriverURLRecognizer result = JDBC_DRIVER_URL_RECOGNIZERS.stream().filter(each -> JDBCDriverURLRecognizerEngine.isMatchURL(url, each)).findAny().orElseThrow(() -> new ShardingSphereException("Cannot resolve JDBC url `%s`. Please implements `%s` and add to SPI.", new Object[]{url, JDBCDriverURLRecognizer.class.getName()}));
        if (result instanceof JDBCDriverComposeURLRecognizer) {
            return ((JDBCDriverComposeURLRecognizer)result).getDriverURLRecognizer(url);
        }
        return result;
    }

    private static boolean isMatchURL(String url, JDBCDriverURLRecognizer jdbcDriverURLRecognizer) {
        return jdbcDriverURLRecognizer.getURLPrefixes().stream().anyMatch(url::startsWith);
    }

    @Generated
    private JDBCDriverURLRecognizerEngine() {
    }

    static {
        for (JDBCDriverURLRecognizer each : ServiceLoader.load(JDBCDriverURLRecognizer.class)) {
            JDBC_DRIVER_URL_RECOGNIZERS.add(each);
        }
    }
}

