/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.datasource.decorator;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import org.apache.shardingsphere.infra.config.datasource.JDBCParameterDecorator;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.ConnectionUrlParser;

public final class HikariJDBCParameterDecorator
implements JDBCParameterDecorator<HikariDataSource> {
    public HikariDataSource decorate(HikariDataSource dataSource) {
        Map<String, String> urlProps = new ConnectionUrlParser(dataSource.getJdbcUrl()).getQueryMap();
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "useServerPrepStmts", Boolean.TRUE.toString());
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "cachePrepStmts", Boolean.TRUE.toString());
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "prepStmtCacheSize", "200000");
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "prepStmtCacheSqlLimit", "2048");
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "useLocalSessionState", Boolean.TRUE.toString());
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "rewriteBatchedStatements", Boolean.TRUE.toString());
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "cacheResultSetMetadata", Boolean.FALSE.toString());
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "cacheServerConfiguration", Boolean.TRUE.toString());
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "elideSetAutoCommits", Boolean.TRUE.toString());
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "maintainTimeStats", Boolean.FALSE.toString());
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "netTimeoutForStreamingResults", "0");
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "tinyInt1isBit", Boolean.FALSE.toString());
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "useSSL", Boolean.FALSE.toString());
        this.addJDBCProperty((HikariConfig)dataSource, urlProps, "serverTimezone", "UTC");
        HikariDataSource result = new HikariDataSource((HikariConfig)dataSource);
        dataSource.close();
        return result;
    }

    private void addJDBCProperty(HikariConfig config, Map<String, String> urlProps, String key, String value) {
        if (urlProps.isEmpty() || !urlProps.containsKey(key)) {
            config.getDataSourceProperties().setProperty(key, value);
        }
    }

    public Class<HikariDataSource> getType() {
        return HikariDataSource.class;
    }
}

