/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.datasource;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.proxy.backend.communication.BackendDataSource;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.rule.builder.DefaultTransactionRuleConfigurationBuilder;
import org.apache.shardingsphere.transaction.spi.ShardingSphereTransactionManager;

public final class JDBCBackendDataSource
implements BackendDataSource {
    public Connection getConnection(String schemaName, String dataSourceName) throws SQLException {
        return this.getConnections(schemaName, dataSourceName, 1, ConnectionMode.MEMORY_STRICTLY).get(0);
    }

    public List<Connection> getConnections(String schemaName, String dataSourceName, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        return this.getConnections(schemaName, dataSourceName, connectionSize, connectionMode, this.getTransactionRule().getDefaultType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Connection> getConnections(String schemaName, String dataSourceName, int connectionSize, ConnectionMode connectionMode, TransactionType transactionType) throws SQLException {
        DataSource dataSource = (DataSource)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(schemaName).getResource().getDataSources().get(dataSourceName);
        Preconditions.checkNotNull((Object)dataSource, (String)"Can not get connection from datasource %s.", (Object)dataSourceName);
        if (1 == connectionSize) {
            return Collections.singletonList(this.createConnection(schemaName, dataSourceName, dataSource, transactionType));
        }
        if (ConnectionMode.CONNECTION_STRICTLY == connectionMode) {
            return this.createConnections(schemaName, dataSourceName, dataSource, connectionSize, transactionType);
        }
        DataSource dataSource2 = dataSource;
        synchronized (dataSource2) {
            return this.createConnections(schemaName, dataSourceName, dataSource, connectionSize, transactionType);
        }
    }

    private List<Connection> createConnections(String schemaName, String dataSourceName, DataSource dataSource, int connectionSize, TransactionType transactionType) throws SQLException {
        ArrayList<Connection> result = new ArrayList<Connection>(connectionSize);
        for (int i = 0; i < connectionSize; ++i) {
            try {
                result.add(this.createConnection(schemaName, dataSourceName, dataSource, transactionType));
                continue;
            }
            catch (SQLException ex) {
                for (Connection each : result) {
                    each.close();
                }
                throw new SQLException(String.format("Could not get %d connections at once. The %d obtained connections have been released. Please consider increasing the `maxPoolSize` of the data sources or decreasing the `max-connections-size-per-query` in props.", connectionSize, result.size()), ex);
            }
        }
        return result;
    }

    private Connection createConnection(String schemaName, String dataSourceName, DataSource dataSource, TransactionType transactionType) throws SQLException {
        ShardingSphereTransactionManager transactionManager = ((ShardingSphereTransactionManagerEngine)ProxyContext.getInstance().getContextManager().getTransactionContexts().getEngines().get(schemaName)).getTransactionManager(transactionType);
        return this.isInTransaction(transactionManager) ? transactionManager.getConnection(dataSourceName) : dataSource.getConnection();
    }

    private boolean isInTransaction(ShardingSphereTransactionManager transactionManager) {
        return null != transactionManager && transactionManager.isInTransaction();
    }

    private TransactionRule getTransactionRule() {
        Optional<TransactionRule> transactionRule = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        return transactionRule.orElseGet(() -> new TransactionRule(new DefaultTransactionRuleConfigurationBuilder().build()));
    }
}

