/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.connection;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;

public final class ConnectionUrlParser {
    private static final String KEY_SCHEME = "scheme";
    private static final String KEY_AUTHORITY = "authority";
    private static final String KEY_PATH = "path";
    private static final String KEY_QUERY = "query";
    private static final Pattern CONNECTION_URL_PATTERN = Pattern.compile("(?<scheme>[\\w\\+:%]+)\\s*(?://(?<authority>[^/?#]*))?\\s*(?:/(?!\\s*/)(?<path>[^?#]*))?(?:\\?(?!\\s*\\?)(?<query>[^#]*))?");
    private final Matcher matcher;
    private final String scheme;
    private final String authority;
    private final String path;
    private final String query;

    public ConnectionUrlParser(String jdbcUrl) {
        this.matcher = CONNECTION_URL_PATTERN.matcher(jdbcUrl);
        if (!this.matcher.matches()) {
            throw new ShardingSphereConfigurationException("Incorrect JDBC url format: %s", new Object[]{jdbcUrl});
        }
        this.scheme = this.matcher.group(KEY_SCHEME);
        this.authority = this.matcher.group(KEY_AUTHORITY);
        this.path = this.matcher.group(KEY_PATH);
        this.query = this.matcher.group(KEY_QUERY);
    }

    public Map<String, String> getQueryMap() {
        if (!Strings.isNullOrEmpty((String)this.query)) {
            return Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)this.query);
        }
        return Collections.emptyMap();
    }

    @Generated
    public Matcher getMatcher() {
        return this.matcher;
    }

    @Generated
    public String getScheme() {
        return this.scheme;
    }

    @Generated
    public String getAuthority() {
        return this.authority;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }
}

