/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.connection;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.netty.util.AttributeMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.parameter.TypeUnspecifiedSQLParameter;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.federate.FederationExecutor;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.ExecutorJDBCManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.SQLStatementSchemaHolder;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.ConnectionPostProcessor;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.ConnectionStatus;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.ResourceLock;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.statement.StatementMemoryStrictlyFetchSizeSetter;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction.TransactionStatus;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPI;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class BackendConnection
implements ExecutorJDBCManager {
    private volatile String schemaName;
    private volatile int connectionId;
    private volatile Grantee grantee;
    private volatile FederationExecutor federationExecutor;
    private final Multimap<String, Connection> cachedConnections = LinkedHashMultimap.create();
    private final Collection<DatabaseCommunicationEngine> databaseCommunicationEngines = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final Collection<DatabaseCommunicationEngine> inUseDatabaseCommunicationEngines = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final Collection<ConnectionPostProcessor> connectionPostProcessors = new LinkedList<ConnectionPostProcessor>();
    private final ResourceLock resourceLock = new ResourceLock();
    private final ConnectionStatus connectionStatus = new ConnectionStatus();
    private final TransactionStatus transactionStatus;
    private final Map<String, StatementMemoryStrictlyFetchSizeSetter> fetchSizeSetters;
    private final AttributeMap attributeMap;

    public BackendConnection(TransactionType initialTransactionType, AttributeMap attributeMap) {
        this.transactionStatus = new TransactionStatus(initialTransactionType);
        this.fetchSizeSetters = ShardingSphereServiceLoader.getSingletonServiceInstances(StatementMemoryStrictlyFetchSizeSetter.class).stream().collect(Collectors.toMap(TypedSPI::getType, Function.identity()));
        this.attributeMap = attributeMap;
    }

    public void setCurrentSchema(String schemaName) {
        if (null != schemaName && schemaName.equals(this.schemaName)) {
            return;
        }
        if (this.transactionStatus.isInTransaction()) {
            throw new ShardingSphereException("Failed to switch schema, please terminate current transaction.", new Object[0]);
        }
        this.schemaName = schemaName;
    }

    public String getSchemaName() {
        return null == SQLStatementSchemaHolder.get() ? this.schemaName : SQLStatementSchemaHolder.get();
    }

    public String getDefaultSchemaName() {
        return this.schemaName;
    }

    public List<Connection> getConnections(String dataSourceName, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        return this.transactionStatus.isInTransaction() ? this.getConnectionsWithTransaction(dataSourceName, connectionSize, connectionMode) : this.getConnectionsWithoutTransaction(dataSourceName, connectionSize, connectionMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connection> getConnectionsWithTransaction(String dataSourceName, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        List<Connection> result;
        Collection connections;
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            connections = this.cachedConnections.get((Object)dataSourceName);
        }
        if (connections.size() >= connectionSize) {
            result = new ArrayList(connections).subList(0, connectionSize);
        } else {
            if (!connections.isEmpty()) {
                result = new ArrayList(connectionSize);
                result.addAll(connections);
                List<Connection> newConnections = this.createNewConnections(dataSourceName, connectionSize - connections.size(), connectionMode);
                result.addAll(newConnections);
                Multimap<String, Connection> multimap2 = this.cachedConnections;
                synchronized (multimap2) {
                    this.cachedConnections.putAll((Object)dataSourceName, newConnections);
                }
            }
            result = this.createNewConnections(dataSourceName, connectionSize, connectionMode);
            Multimap<String, Connection> multimap3 = this.cachedConnections;
            synchronized (multimap3) {
                this.cachedConnections.putAll((Object)dataSourceName, result);
            }
        }
        return result;
    }

    private List<Connection> createNewConnections(String dataSourceName, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        Preconditions.checkNotNull((Object)this.getSchemaName(), (Object)"Current schema is null.");
        List<Connection> result = ProxyContext.getInstance().getBackendDataSource().getConnections(this.getSchemaName(), dataSourceName, connectionSize, connectionMode);
        for (Connection each : result) {
            this.replayMethodsInvocation(each);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connection> getConnectionsWithoutTransaction(String dataSourceName, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        Preconditions.checkNotNull((Object)this.getSchemaName(), (Object)"Current schema is null.");
        List<Connection> result = ProxyContext.getInstance().getBackendDataSource().getConnections(this.getSchemaName(), dataSourceName, connectionSize, connectionMode);
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            this.cachedConnections.putAll((Object)dataSourceName, result);
        }
        return result;
    }

    private void replayMethodsInvocation(Connection target) {
        for (ConnectionPostProcessor each : this.connectionPostProcessors) {
            each.process(target);
        }
    }

    public Statement createStorageResource(Connection connection, ConnectionMode connectionMode, StatementOption option) throws SQLException {
        Statement result = connection.createStatement();
        if (ConnectionMode.MEMORY_STRICTLY == connectionMode) {
            this.setFetchSize(result);
        }
        return result;
    }

    public PreparedStatement createStorageResource(String sql, List<Object> parameters, Connection connection, ConnectionMode connectionMode, StatementOption option) throws SQLException {
        PreparedStatement result = option.isReturnGeneratedKeys() ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql);
        for (int i = 0; i < parameters.size(); ++i) {
            Object parameter = parameters.get(i);
            if (parameter instanceof TypeUnspecifiedSQLParameter) {
                result.setObject(i + 1, parameter, 1111);
                continue;
            }
            result.setObject(i + 1, parameter);
        }
        if (ConnectionMode.MEMORY_STRICTLY == connectionMode) {
            this.setFetchSize(result);
        }
        return result;
    }

    private void setFetchSize(Statement statement) throws SQLException {
        DatabaseType databaseType = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(this.getSchemaName()).getResource().getDatabaseType();
        if (this.fetchSizeSetters.containsKey(databaseType.getName())) {
            this.fetchSizeSetters.get(databaseType.getName()).setFetchSize(statement);
        }
    }

    public boolean isSerialExecute() {
        return this.transactionStatus.isInTransaction() && (TransactionType.LOCAL == this.transactionStatus.getTransactionType() || TransactionType.XA == this.transactionStatus.getTransactionType());
    }

    public int getConnectionSize() {
        return this.cachedConnections.values().size();
    }

    public void add(DatabaseCommunicationEngine databaseCommunicationEngine) {
        this.databaseCommunicationEngines.add(databaseCommunicationEngine);
    }

    public void markResourceInUse(DatabaseCommunicationEngine databaseCommunicationEngine) {
        this.inUseDatabaseCommunicationEngines.add(databaseCommunicationEngine);
    }

    public void unmarkResourceInUse(DatabaseCommunicationEngine databaseCommunicationEngine) {
        this.inUseDatabaseCommunicationEngines.remove(databaseCommunicationEngine);
    }

    public synchronized Collection<SQLException> closeDatabaseCommunicationEngines(boolean includeInUse) {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (DatabaseCommunicationEngine each : this.databaseCommunicationEngines) {
            if (!includeInUse && this.inUseDatabaseCommunicationEngines.contains(each)) continue;
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        if (includeInUse) {
            this.inUseDatabaseCommunicationEngines.clear();
        }
        this.databaseCommunicationEngines.retainAll(this.inUseDatabaseCommunicationEngines);
        return result;
    }

    public synchronized Collection<SQLException> closeConnections(boolean forceRollback) {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.cachedConnections.values()) {
            try {
                if (forceRollback && this.transactionStatus.isInTransaction()) {
                    each.rollback();
                }
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.cachedConnections.clear();
        this.connectionPostProcessors.clear();
        return result;
    }

    public synchronized Collection<SQLException> closeFederationExecutor() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        if (null != this.federationExecutor) {
            try {
                this.federationExecutor.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        return result;
    }

    @Generated
    public int getConnectionId() {
        return this.connectionId;
    }

    @Generated
    public Grantee getGrantee() {
        return this.grantee;
    }

    @Generated
    public FederationExecutor getFederationExecutor() {
        return this.federationExecutor;
    }

    @Generated
    public Multimap<String, Connection> getCachedConnections() {
        return this.cachedConnections;
    }

    @Generated
    public Collection<DatabaseCommunicationEngine> getDatabaseCommunicationEngines() {
        return this.databaseCommunicationEngines;
    }

    @Generated
    public Collection<DatabaseCommunicationEngine> getInUseDatabaseCommunicationEngines() {
        return this.inUseDatabaseCommunicationEngines;
    }

    @Generated
    public Collection<ConnectionPostProcessor> getConnectionPostProcessors() {
        return this.connectionPostProcessors;
    }

    @Generated
    public ResourceLock getResourceLock() {
        return this.resourceLock;
    }

    @Generated
    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    @Generated
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    @Generated
    public Map<String, StatementMemoryStrictlyFetchSizeSetter> getFetchSizeSetters() {
        return this.fetchSizeSetters;
    }

    @Generated
    public AttributeMap getAttributeMap() {
        return this.attributeMap;
    }

    @Generated
    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }

    @Generated
    public void setGrantee(Grantee grantee) {
        this.grantee = grantee;
    }

    @Generated
    public void setFederationExecutor(FederationExecutor federationExecutor) {
        this.federationExecutor = federationExecutor;
    }

    static {
        ShardingSphereServiceLoader.register(StatementMemoryStrictlyFetchSizeSetter.class);
    }
}

