/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.sane.JDBCSaneQueryResultEngineFactory;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.federate.FederationExecutor;
import org.apache.shardingsphere.infra.executor.sql.federate.FederationExecutorFactory;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorDriverManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.raw.RawExecutionPrepareEngine;
import org.apache.shardingsphere.infra.optimize.context.OptimizerContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.RawExecutionRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.ProxyJDBCExecutor;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.callback.ProxyJDBCExecutorCallback;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.callback.ProxyJDBCExecutorCallbackFactory;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction.TransactionStatus;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.TableModifyInTransactionException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLInsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.OpenGaussStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.PostgreSQLStatement;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class ProxySQLExecutor {
    private final String type;
    private final BackendConnection backendConnection;
    private final DatabaseCommunicationEngine databaseCommunicationEngine;
    private final ProxyJDBCExecutor jdbcExecutor;
    private final RawExecutor rawExecutor;
    private final FederationExecutor federationExecutor;

    public ProxySQLExecutor(String type, BackendConnection backendConnection, DatabaseCommunicationEngine databaseCommunicationEngine) {
        this.type = type;
        this.backendConnection = backendConnection;
        this.databaseCommunicationEngine = databaseCommunicationEngine;
        ExecutorEngine executorEngine = BackendExecutorContext.getInstance().getExecutorEngine();
        boolean isSerialExecute = backendConnection.isSerialExecute();
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        this.jdbcExecutor = new ProxyJDBCExecutor(type, backendConnection, databaseCommunicationEngine, new JDBCExecutor(executorEngine, isSerialExecute));
        this.rawExecutor = new RawExecutor(executorEngine, isSerialExecute, metaDataContexts.getProps());
        this.federationExecutor = FederationExecutorFactory.newInstance((String)backendConnection.getSchemaName(), (OptimizerContext)metaDataContexts.getOptimizerContext(), (ConfigurationProperties)metaDataContexts.getProps(), (JDBCExecutor)new JDBCExecutor(executorEngine, isSerialExecute));
    }

    public void checkExecutePrerequisites(ExecutionContext executionContext) {
        if (this.isExecuteDDLInXATransaction(executionContext.getSqlStatementContext().getSqlStatement()) || this.isExecuteDDLInPostgreSQLOpenGaussTransaction(executionContext.getSqlStatementContext().getSqlStatement())) {
            throw new TableModifyInTransactionException(executionContext.getSqlStatementContext());
        }
    }

    private boolean isExecuteDDLInXATransaction(SQLStatement sqlStatement) {
        TransactionStatus transactionStatus = this.backendConnection.getTransactionStatus();
        return TransactionType.XA == transactionStatus.getTransactionType() && sqlStatement instanceof DDLStatement && transactionStatus.isInTransaction();
    }

    private boolean isExecuteDDLInPostgreSQLOpenGaussTransaction(SQLStatement sqlStatement) {
        boolean isPostgreSQLOpenGaussStatement = sqlStatement instanceof PostgreSQLStatement || sqlStatement instanceof OpenGaussStatement;
        return sqlStatement instanceof DDLStatement && isPostgreSQLOpenGaussStatement && this.backendConnection.getTransactionStatus().isInTransaction();
    }

    public Collection<ExecuteResult> execute(ExecutionContext executionContext) throws SQLException {
        Collection rules = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(this.backendConnection.getSchemaName()).getRuleMetaData().getRules();
        int maxConnectionsSizePerQuery = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        boolean isReturnGeneratedKeys = executionContext.getSqlStatementContext().getSqlStatement() instanceof MySQLInsertStatement;
        return this.execute(executionContext, rules, maxConnectionsSizePerQuery, isReturnGeneratedKeys);
    }

    private Collection<ExecuteResult> execute(ExecutionContext executionContext, Collection<ShardingSphereRule> rules, int maxConnectionsSizePerQuery, boolean isReturnGeneratedKeys) throws SQLException {
        if (rules.stream().anyMatch(each -> each instanceof RawExecutionRule)) {
            return this.rawExecute(executionContext, rules, maxConnectionsSizePerQuery);
        }
        if (executionContext.getRouteContext().isFederated()) {
            return this.federateExecute(executionContext, isReturnGeneratedKeys, SQLExecutorExceptionHandler.isExceptionThrown());
        }
        return this.useDriverToExecute(executionContext, rules, maxConnectionsSizePerQuery, isReturnGeneratedKeys, SQLExecutorExceptionHandler.isExceptionThrown());
    }

    private Collection<ExecuteResult> rawExecute(ExecutionContext executionContext, Collection<ShardingSphereRule> rules, int maxConnectionsSizePerQuery) throws SQLException {
        ExecutionGroupContext executionGroupContext;
        RawExecutionPrepareEngine prepareEngine = new RawExecutionPrepareEngine(maxConnectionsSizePerQuery, rules);
        try {
            executionGroupContext = prepareEngine.prepare(executionContext.getRouteContext(), executionContext.getExecutionUnits());
        }
        catch (SQLException ex) {
            return this.getSaneExecuteResults(executionContext, ex);
        }
        executionGroupContext.setSchemaName(this.backendConnection.getSchemaName());
        executionGroupContext.setGrantee(this.backendConnection.getGrantee());
        return this.rawExecutor.execute(executionGroupContext, executionContext.getLogicSQL(), new RawSQLExecutorCallback());
    }

    private Collection<ExecuteResult> federateExecute(ExecutionContext executionContext, boolean isReturnGeneratedKeys, boolean isExceptionThrown) throws SQLException {
        if (executionContext.getExecutionUnits().isEmpty()) {
            return Collections.emptyList();
        }
        MetaDataContexts metaData = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        ProxyJDBCExecutorCallback callback = ProxyJDBCExecutorCallbackFactory.newInstance(this.type, metaData.getMetaData(this.backendConnection.getSchemaName()).getResource().getDatabaseType(), executionContext.getSqlStatementContext().getSqlStatement(), this.databaseCommunicationEngine, isReturnGeneratedKeys, isExceptionThrown, true);
        this.backendConnection.setFederationExecutor(this.federationExecutor);
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine(isReturnGeneratedKeys, metaData);
        return this.federationExecutor.executeQuery(prepareEngine, (JDBCExecutorCallback)callback, executionContext).stream().map(each -> each).collect(Collectors.toList());
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine(boolean isReturnGeneratedKeys, MetaDataContexts metaData) {
        int maxConnectionsSizePerQuery = (Integer)metaData.getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new DriverExecutionPrepareEngine(this.type, maxConnectionsSizePerQuery, (ExecutorDriverManager)this.backendConnection, (StorageResourceOption)new StatementOption(isReturnGeneratedKeys), metaData.getMetaData(this.backendConnection.getSchemaName()).getRuleMetaData().getRules());
    }

    private Collection<ExecuteResult> useDriverToExecute(ExecutionContext executionContext, Collection<ShardingSphereRule> rules, int maxConnectionsSizePerQuery, boolean isReturnGeneratedKeys, boolean isExceptionThrown) throws SQLException {
        ExecutionGroupContext executionGroupContext;
        DriverExecutionPrepareEngine prepareEngine = new DriverExecutionPrepareEngine(this.type, maxConnectionsSizePerQuery, (ExecutorDriverManager)this.backendConnection, (StorageResourceOption)new StatementOption(isReturnGeneratedKeys), rules);
        try {
            executionGroupContext = prepareEngine.prepare(executionContext.getRouteContext(), executionContext.getExecutionUnits());
        }
        catch (SQLException ex) {
            return this.getSaneExecuteResults(executionContext, ex);
        }
        executionGroupContext.setSchemaName(this.backendConnection.getSchemaName());
        executionGroupContext.setGrantee(this.backendConnection.getGrantee());
        return this.jdbcExecutor.execute(executionContext.getLogicSQL(), (ExecutionGroupContext<JDBCExecutionUnit>)executionGroupContext, isReturnGeneratedKeys, isExceptionThrown);
    }

    private Collection<ExecuteResult> getSaneExecuteResults(ExecutionContext executionContext, SQLException originalException) throws SQLException {
        DatabaseType databaseType = ProxyContext.getInstance().getMetaData(this.backendConnection.getSchemaName()).getResource().getDatabaseType();
        Optional executeResult = JDBCSaneQueryResultEngineFactory.newInstance((DatabaseType)databaseType).getSaneQueryResult(executionContext.getSqlStatementContext().getSqlStatement());
        if (executeResult.isPresent()) {
            return Collections.singleton(executeResult.get());
        }
        throw originalException;
    }
}

