/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefreshEngine;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.lock.LockNameUtil;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.proxy.backend.communication.ProxySQLExecutor;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.TableLockWaitTimeoutException;
import org.apache.shardingsphere.proxy.backend.exception.TableLockedException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class ProxyLockEngine {
    private final ProxySQLExecutor proxySQLExecutor;
    private final MetaDataRefreshEngine metadataRefreshEngine;
    private final String schemaName;
    private final Collection<String> lockNames = new ArrayList<String>();

    public ProxyLockEngine(ProxySQLExecutor proxySQLExecutor, MetaDataRefreshEngine metadataRefreshEngine, String schemaName) {
        this.proxySQLExecutor = proxySQLExecutor;
        this.metadataRefreshEngine = metadataRefreshEngine;
        this.schemaName = schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ExecuteResult> execute(ExecutionContext executionContext) throws SQLException {
        if (ProxyContext.getInstance().getLock().isPresent()) {
            ShardingSphereLock lock = ProxyContext.getInstance().getLock().get();
            try {
                SQLStatement sqlStatement = executionContext.getSqlStatementContext().getSqlStatement();
                if (sqlStatement instanceof DDLStatement) {
                    this.tryTableLock(lock, executionContext.getSqlStatementContext().getTablesContext().getTableNames());
                } else if (sqlStatement instanceof DMLStatement && !(sqlStatement instanceof SelectStatement)) {
                    this.checkTableLock(lock, executionContext.getSqlStatementContext().getTablesContext().getTableNames());
                }
                Collection<ExecuteResult> collection = this.doExecute(executionContext);
                return collection;
            }
            finally {
                if (!this.lockNames.isEmpty()) {
                    this.lockNames.forEach(arg_0 -> ((ShardingSphereLock)lock).releaseLock(arg_0));
                }
            }
        }
        return this.doExecute(executionContext);
    }

    private void tryTableLock(ShardingSphereLock lock, Collection<String> tableNames) {
        for (String each : tableNames) {
            String lockName = LockNameUtil.getTableLockName((String)this.schemaName, (String)each);
            if (!lock.tryLock(lockName)) {
                throw new TableLockWaitTimeoutException(this.schemaName, each, lock.getDefaultTimeOut());
            }
            this.lockNames.add(lockName);
        }
    }

    private void checkTableLock(ShardingSphereLock lock, Collection<String> tableNames) {
        for (String each : tableNames) {
            if (!lock.isLocked(LockNameUtil.getTableLockName((String)this.schemaName, (String)each))) continue;
            throw new TableLockedException(this.schemaName, each);
        }
    }

    private Collection<ExecuteResult> doExecute(ExecutionContext executionContext) throws SQLException {
        Collection<ExecuteResult> result = this.proxySQLExecutor.execute(executionContext);
        this.refreshMetaData(executionContext);
        return result;
    }

    private void refreshMetaData(ExecutionContext executionContext) throws SQLException {
        SQLStatement sqlStatement = executionContext.getSqlStatementContext().getSqlStatement();
        this.metadataRefreshEngine.refresh(sqlStatement, (Collection)executionContext.getRouteContext().getRouteUnits().stream().map(each -> each.getDataSourceMapper().getLogicName()).collect(Collectors.toList()));
    }
}

