/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;

public final class DatabaseCommunicationEngineFactory {
    private static final DatabaseCommunicationEngineFactory INSTANCE = new DatabaseCommunicationEngineFactory();

    public static DatabaseCommunicationEngineFactory getInstance() {
        return INSTANCE;
    }

    public DatabaseCommunicationEngine newTextProtocolInstance(SQLStatementContext<?> sqlStatementContext, String sql, BackendConnection backendConnection) {
        ShardingSphereMetaData metaData = ProxyContext.getInstance().getMetaData(backendConnection.getSchemaName());
        LogicSQL logicSQL = new LogicSQL(sqlStatementContext, sql, Collections.emptyList());
        DatabaseCommunicationEngine result = new DatabaseCommunicationEngine("JDBC.STATEMENT", metaData, logicSQL, backendConnection);
        backendConnection.add(result);
        return result;
    }

    public DatabaseCommunicationEngine newBinaryProtocolInstance(SQLStatementContext<?> sqlStatementContext, String sql, List<Object> parameters, BackendConnection backendConnection) {
        ShardingSphereMetaData metaData = ProxyContext.getInstance().getMetaData(backendConnection.getSchemaName());
        LogicSQL logicSQL = new LogicSQL(sqlStatementContext, sql, parameters);
        DatabaseCommunicationEngine result = new DatabaseCommunicationEngine("JDBC.PREPARED_STATEMENT", metaData, logicSQL, backendConnection);
        backendConnection.add(result);
        return result;
    }

    @Generated
    private DatabaseCommunicationEngineFactory() {
    }
}

