/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefreshEngine;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.optimize.metadata.FederationSchemaMetaData;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.proxy.backend.communication.ProxyLockEngine;
import org.apache.shardingsphere.proxy.backend.communication.ProxySQLExecutor;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.data.impl.BinaryQueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.impl.TextQueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeaderBuilder;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;

public final class DatabaseCommunicationEngine {
    private final String driverType;
    private final ShardingSphereMetaData metaData;
    private final LogicSQL logicSQL;
    private final ProxySQLExecutor proxySQLExecutor;
    private final KernelProcessor kernelProcessor;
    private List<QueryHeader> queryHeaders;
    private MergedResult mergedResult;
    private ProxyLockEngine proxyLockEngine;
    private final Collection<Statement> cachedStatements = new CopyOnWriteArrayList<Statement>();
    private final Collection<ResultSet> cachedResultSets = new CopyOnWriteArrayList<ResultSet>();

    public DatabaseCommunicationEngine(String driverType, ShardingSphereMetaData metaData, LogicSQL logicSQL, BackendConnection backendConnection) {
        this.driverType = driverType;
        this.metaData = metaData;
        this.logicSQL = logicSQL;
        this.proxySQLExecutor = new ProxySQLExecutor(driverType, backendConnection, this);
        this.kernelProcessor = new KernelProcessor();
        this.proxyLockEngine = new ProxyLockEngine(this.proxySQLExecutor, new MetaDataRefreshEngine(metaData, (FederationSchemaMetaData)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getOptimizerContext().getMetaData().getSchemas().get(backendConnection.getSchemaName()), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps()), backendConnection.getSchemaName());
    }

    public void add(Statement statement) {
        this.cachedStatements.add(statement);
    }

    public void add(ResultSet resultSet) {
        this.cachedResultSets.add(resultSet);
    }

    public ResponseHeader execute() throws SQLException {
        ExecutionContext executionContext = this.kernelProcessor.generateExecutionContext(this.logicSQL, this.metaData, ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps());
        if (executionContext.getExecutionUnits().isEmpty()) {
            return new UpdateResponseHeader(executionContext.getSqlStatementContext().getSqlStatement());
        }
        this.proxySQLExecutor.checkExecutePrerequisites(executionContext);
        Collection<ExecuteResult> executeResults = this.proxyLockEngine.execute(executionContext);
        ExecuteResult executeResultSample = executeResults.iterator().next();
        return executeResultSample instanceof QueryResult ? this.processExecuteQuery(executionContext, executeResults.stream().map(each -> (QueryResult)each).collect(Collectors.toList()), (QueryResult)executeResultSample) : this.processExecuteUpdate(executionContext, executeResults.stream().map(each -> (UpdateResult)each).collect(Collectors.toList()));
    }

    private QueryResponseHeader processExecuteQuery(ExecutionContext executionContext, List<QueryResult> queryResults, QueryResult queryResultSample) throws SQLException {
        this.queryHeaders = this.createQueryHeaders(executionContext, queryResultSample);
        this.mergedResult = this.mergeQuery(executionContext.getSqlStatementContext(), queryResults);
        return new QueryResponseHeader(this.queryHeaders);
    }

    private List<QueryHeader> createQueryHeaders(ExecutionContext executionContext, QueryResult queryResultSample) throws SQLException {
        int columnCount = this.getColumnCount(executionContext, queryResultSample);
        ArrayList<QueryHeader> result = new ArrayList<QueryHeader>(columnCount);
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            result.add(this.createQueryHeader(executionContext, queryResultSample, this.metaData, columnIndex));
        }
        return result;
    }

    private QueryHeader createQueryHeader(ExecutionContext executionContext, QueryResult queryResultSample, ShardingSphereMetaData metaData, int columnIndex) throws SQLException {
        return this.hasSelectExpandProjections(executionContext.getSqlStatementContext()) ? QueryHeaderBuilder.build(((SelectStatementContext)executionContext.getSqlStatementContext()).getProjectionsContext(), queryResultSample.getMetaData(), metaData, columnIndex) : QueryHeaderBuilder.build(queryResultSample.getMetaData(), metaData, columnIndex);
    }

    private int getColumnCount(ExecutionContext executionContext, QueryResult queryResultSample) throws SQLException {
        return this.hasSelectExpandProjections(executionContext.getSqlStatementContext()) ? ((SelectStatementContext)executionContext.getSqlStatementContext()).getProjectionsContext().getExpandProjections().size() : queryResultSample.getMetaData().getColumnCount();
    }

    private boolean hasSelectExpandProjections(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && !((SelectStatementContext)sqlStatementContext).getProjectionsContext().getExpandProjections().isEmpty() && !((SelectStatementContext)sqlStatementContext).isContainsSubquery();
    }

    private MergedResult mergeQuery(SQLStatementContext<?> sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        MergeEngine mergeEngine = new MergeEngine("logic_db", ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(this.metaData.getName()).getResource().getDatabaseType(), this.metaData.getSchema(), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps(), this.metaData.getRuleMetaData().getRules());
        return mergeEngine.merge(queryResults, sqlStatementContext);
    }

    private UpdateResponseHeader processExecuteUpdate(ExecutionContext executionContext, Collection<UpdateResult> updateResults) {
        UpdateResponseHeader result = new UpdateResponseHeader(executionContext.getSqlStatementContext().getSqlStatement(), updateResults);
        this.mergeUpdateCount(executionContext.getSqlStatementContext(), result);
        return result;
    }

    private void mergeUpdateCount(SQLStatementContext<?> sqlStatementContext, UpdateResponseHeader response) {
        if (this.isNeedAccumulate(sqlStatementContext)) {
            response.mergeUpdateCount();
        }
    }

    private boolean isNeedAccumulate(SQLStatementContext<?> sqlStatementContext) {
        Optional<DataNodeContainedRule> dataNodeContainedRule = this.metaData.getRuleMetaData().getRules().stream().filter(each -> each instanceof DataNodeContainedRule).findFirst().map(rule -> (DataNodeContainedRule)rule);
        return dataNodeContainedRule.isPresent() && dataNodeContainedRule.get().isNeedAccumulate(sqlStatementContext.getTablesContext().getTableNames());
    }

    public boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    public QueryResponseRow getQueryResponseRow() throws SQLException {
        ArrayList<QueryResponseCell> cells = new ArrayList<QueryResponseCell>(this.queryHeaders.size());
        boolean isBinary = this.isBinary();
        for (int columnIndex = 1; columnIndex <= this.queryHeaders.size(); ++columnIndex) {
            Object data = this.mergedResult.getValue(columnIndex, Object.class);
            if (isBinary) {
                cells.add(new BinaryQueryResponseCell(this.queryHeaders.get(columnIndex - 1).getColumnType(), data));
                continue;
            }
            cells.add(new TextQueryResponseCell(data));
        }
        return new QueryResponseRow(cells);
    }

    private boolean isBinary() {
        return "JDBC.PREPARED_STATEMENT".equals(this.driverType);
    }

    public void close() throws SQLException {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        result.addAll(this.closeResultSets());
        result.addAll(this.closeStatements());
        if (result.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException();
        result.forEach(ex::setNextException);
        throw ex;
    }

    private Collection<SQLException> closeResultSets() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (ResultSet each : this.cachedResultSets) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.cachedResultSets.clear();
        return result;
    }

    private Collection<SQLException> closeStatements() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Statement each : this.cachedStatements) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.cachedStatements.clear();
        return result;
    }

    @Generated
    public DatabaseCommunicationEngine(String driverType, ShardingSphereMetaData metaData, LogicSQL logicSQL, ProxySQLExecutor proxySQLExecutor, KernelProcessor kernelProcessor) {
        this.driverType = driverType;
        this.metaData = metaData;
        this.logicSQL = logicSQL;
        this.proxySQLExecutor = proxySQLExecutor;
        this.kernelProcessor = kernelProcessor;
    }
}

