/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.parser.core;

import java.util.Properties;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.ScalingStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.ScalingStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.scaling.distsql.statement.CheckScalingStatement;
import org.apache.shardingsphere.scaling.distsql.statement.CheckoutScalingStatement;
import org.apache.shardingsphere.scaling.distsql.statement.DropScalingStatement;
import org.apache.shardingsphere.scaling.distsql.statement.ResetScalingStatement;
import org.apache.shardingsphere.scaling.distsql.statement.ShowScalingCheckAlgorithmsStatement;
import org.apache.shardingsphere.scaling.distsql.statement.ShowScalingListStatement;
import org.apache.shardingsphere.scaling.distsql.statement.ShowScalingStatusStatement;
import org.apache.shardingsphere.scaling.distsql.statement.StartScalingStatement;
import org.apache.shardingsphere.scaling.distsql.statement.StopScalingSourceWritingStatement;
import org.apache.shardingsphere.scaling.distsql.statement.StopScalingStatement;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ScalingSQLStatementVisitor
extends ScalingStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitShowScalingList(ScalingStatementParser.ShowScalingListContext ctx) {
        return new ShowScalingListStatement();
    }

    @Override
    public ASTNode visitShowScalingStatus(ScalingStatementParser.ShowScalingStatusContext ctx) {
        return new ShowScalingStatusStatement(Long.parseLong(ctx.jobId().getText()));
    }

    @Override
    public ASTNode visitStartScaling(ScalingStatementParser.StartScalingContext ctx) {
        return new StartScalingStatement(Long.parseLong(ctx.jobId().getText()));
    }

    @Override
    public ASTNode visitStopScaling(ScalingStatementParser.StopScalingContext ctx) {
        return new StopScalingStatement(Long.parseLong(ctx.jobId().getText()));
    }

    @Override
    public ASTNode visitDropScaling(ScalingStatementParser.DropScalingContext ctx) {
        return new DropScalingStatement(Long.parseLong(ctx.jobId().getText()));
    }

    @Override
    public ASTNode visitResetScaling(ScalingStatementParser.ResetScalingContext ctx) {
        return new ResetScalingStatement(Long.parseLong(ctx.jobId().getText()));
    }

    @Override
    public ASTNode visitCheckScaling(ScalingStatementParser.CheckScalingContext ctx) {
        AlgorithmSegment typeStrategy = null;
        if (null != ctx.algorithmDefinition()) {
            typeStrategy = (AlgorithmSegment)this.visit((ParseTree)ctx.algorithmDefinition());
        }
        return new CheckScalingStatement(Long.parseLong(ctx.jobId().getText()), typeStrategy);
    }

    @Override
    public ASTNode visitShowScalingCheckAlgorithms(ScalingStatementParser.ShowScalingCheckAlgorithmsContext ctx) {
        return new ShowScalingCheckAlgorithmsStatement();
    }

    @Override
    public ASTNode visitStopScalingSourceWriting(ScalingStatementParser.StopScalingSourceWritingContext ctx) {
        return new StopScalingSourceWritingStatement(Long.parseLong(ctx.jobId().getText()));
    }

    @Override
    public ASTNode visitCheckoutScaling(ScalingStatementParser.CheckoutScalingContext ctx) {
        return new CheckoutScalingStatement(Long.parseLong(ctx.jobId().getText()));
    }

    @Override
    public ASTNode visitAlgorithmDefinition(ScalingStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(ctx.algorithmName().getText(), this.getAlgorithmProperties(ctx));
    }

    private Properties getAlgorithmProperties(ScalingStatementParser.AlgorithmDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx.algorithmProperties()) {
            return result;
        }
        for (ScalingStatementParser.AlgorithmPropertyContext each : ctx.algorithmProperties().algorithmProperty()) {
            result.setProperty(new IdentifierValue(each.key.getText()).getValue(), new IdentifierValue(each.value.getText()).getValue());
        }
        return result;
    }
}

