/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.state.impl;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.ExecutorService;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecutorTask;
import org.apache.shardingsphere.proxy.frontend.executor.ConnectionThreadExecutorGroup;
import org.apache.shardingsphere.proxy.frontend.executor.UserExecutorGroup;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;
import org.apache.shardingsphere.proxy.frontend.state.ProxyState;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class OKProxyState
implements ProxyState {
    @Override
    public void execute(ChannelHandlerContext context, Object message, DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine, BackendConnection backendConnection) {
        CommandExecutorTask commandExecutorTask = new CommandExecutorTask(databaseProtocolFrontendEngine, backendConnection, context, message);
        ExecutorService executorService = this.determineSuitableExecutorService(context, databaseProtocolFrontendEngine, backendConnection);
        executorService.execute(commandExecutorTask);
    }

    private ExecutorService determineSuitableExecutorService(ChannelHandlerContext context, DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine, BackendConnection backendConnection) {
        Object result = this.requireOccupyThreadForConnection(backendConnection) ? ConnectionThreadExecutorGroup.getInstance().get(backendConnection.getConnectionId()) : (this.isPreferNettyEventLoop() ? context.executor() : (databaseProtocolFrontendEngine.getFrontendContext().isRequiredSameThreadForConnection() ? ConnectionThreadExecutorGroup.getInstance().get(backendConnection.getConnectionId()) : UserExecutorGroup.getInstance().getExecutorService()));
        return result;
    }

    private boolean requireOccupyThreadForConnection(BackendConnection backendConnection) {
        return (Boolean)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_HINT_ENABLED) != false || TransactionType.isDistributedTransaction((TransactionType)backendConnection.getTransactionStatus().getTransactionType());
    }

    private boolean isPreferNettyEventLoop() {
        switch ((String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_BACKEND_EXECUTOR_SUITABLE)) {
            case "OLTP": {
                return true;
            }
            case "OLAP": {
                return false;
            }
        }
        throw new IllegalArgumentException("The property proxy-backend-executor-suitable must be 'OLAP' or 'OLTP'");
    }
}

