/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.protocol;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;

public final class FrontDatabaseProtocolTypeFactory {
    private static final String DEFAULT_FRONTEND_DATABASE_PROTOCOL_TYPE = "MySQL";

    public static DatabaseType getDatabaseType() {
        Optional<DatabaseType> configuredDatabaseType = FrontDatabaseProtocolTypeFactory.findConfiguredDatabaseType();
        if (configuredDatabaseType.isPresent()) {
            return configuredDatabaseType.get();
        }
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        if (metaDataContexts.getMetaDataMap().isEmpty()) {
            return DatabaseTypeRegistry.getTrunkDatabaseType((String)DEFAULT_FRONTEND_DATABASE_PROTOCOL_TYPE);
        }
        Optional<ShardingSphereMetaData> metaDataOptional = metaDataContexts.getMetaDataMap().values().stream().filter(ShardingSphereMetaData::isComplete).findFirst();
        if (!metaDataOptional.isPresent()) {
            return DatabaseTypeRegistry.getTrunkDatabaseType((String)DEFAULT_FRONTEND_DATABASE_PROTOCOL_TYPE);
        }
        return metaDataOptional.get().getResource().getDatabaseType();
    }

    private static Optional<DatabaseType> findConfiguredDatabaseType() {
        String configuredDatabaseType = (String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE);
        return configuredDatabaseType.isEmpty() ? Optional.empty() : Optional.of(DatabaseTypeRegistry.getTrunkDatabaseType((String)configuredDatabaseType));
    }

    @Generated
    private FrontDatabaseProtocolTypeFactory() {
    }
}

