/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.codec.PacketCodec;
import org.apache.shardingsphere.db.protocol.netty.ChannelAttrInitializer;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.proxy.frontend.netty.FrontendChannelInboundHandler;
import org.apache.shardingsphere.proxy.frontend.netty.FrontendChannelLimitationInboundHandler;
import org.apache.shardingsphere.proxy.frontend.protocol.DatabaseProtocolFrontendEngineFactory;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;

public final class ServerHandlerInitializer
extends ChannelInitializer<SocketChannel> {
    private final DatabaseType databaseType;

    protected void initChannel(SocketChannel socketChannel) {
        DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine = DatabaseProtocolFrontendEngineFactory.newInstance(this.databaseType);
        ChannelPipeline pipeline = socketChannel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new ChannelAttrInitializer()});
        pipeline.addLast(new ChannelHandler[]{new PacketCodec(databaseProtocolFrontendEngine.getCodecEngine())});
        pipeline.addLast(new ChannelHandler[]{new FrontendChannelLimitationInboundHandler(databaseProtocolFrontendEngine)});
        pipeline.addLast(new ChannelHandler[]{new FrontendChannelInboundHandler(databaseProtocolFrontendEngine, (Channel)socketChannel)});
    }

    @Generated
    public ServerHandlerInitializer(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

