/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import lombok.Generated;
import org.apache.shardingsphere.proxy.frontend.connection.ConnectionLimitContext;
import org.apache.shardingsphere.proxy.frontend.exception.FrontendTooManyConnectionsException;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendChannelLimitationInboundHandler
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FrontendChannelLimitationInboundHandler.class);
    private final DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine;

    public void channelActive(ChannelHandlerContext ctx) {
        if (ConnectionLimitContext.getInstance().connectionAllowed()) {
            ctx.fireChannelActive();
            return;
        }
        log.debug("Closing channel {} due to the number of server connections has reached max connections {}", (Object)ctx.channel().remoteAddress(), (Object)ConnectionLimitContext.getInstance().getMaxConnections());
        ctx.writeAndFlush((Object)this.databaseProtocolFrontendEngine.getCommandExecuteEngine().getErrorPacket((Exception)new FrontendTooManyConnectionsException()));
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ctx.fireChannelInactive();
        ConnectionLimitContext.getInstance().connectionInactive();
    }

    @Generated
    public FrontendChannelLimitationInboundHandler(DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine) {
        this.databaseProtocolFrontendEngine = databaseProtocolFrontendEngine;
    }
}

