/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeMap;
import java.nio.charset.Charset;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationResult;
import org.apache.shardingsphere.proxy.frontend.executor.ConnectionThreadExecutorGroup;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;
import org.apache.shardingsphere.proxy.frontend.state.ProxyStateContext;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.rule.builder.DefaultTransactionRuleConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FrontendChannelInboundHandler
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FrontendChannelInboundHandler.class);
    private final DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine;
    private final BackendConnection backendConnection;
    private volatile boolean authenticated;

    public FrontendChannelInboundHandler(DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine, Channel channel) {
        this.databaseProtocolFrontendEngine = databaseProtocolFrontendEngine;
        this.backendConnection = new BackendConnection(this.getTransactionRule().getDefaultType(), (AttributeMap)channel);
    }

    private TransactionRule getTransactionRule() {
        Optional<TransactionRule> transactionRule = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        return transactionRule.orElseGet(() -> new TransactionRule(new DefaultTransactionRuleConfigurationBuilder().build()));
    }

    public void channelActive(ChannelHandlerContext context) {
        int connectionId = this.databaseProtocolFrontendEngine.getAuthenticationEngine().handshake(context);
        ConnectionThreadExecutorGroup.getInstance().register(connectionId);
        this.backendConnection.setConnectionId(connectionId);
    }

    public void channelRead(ChannelHandlerContext context, Object message) {
        if (!this.authenticated) {
            this.authenticated = this.authenticate(context, (ByteBuf)message);
            return;
        }
        ProxyStateContext.execute(context, message, this.databaseProtocolFrontendEngine, this.backendConnection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean authenticate(ChannelHandlerContext context, ByteBuf message) {
        try (PacketPayload payload = this.databaseProtocolFrontendEngine.getCodecEngine().createPacketPayload(message, (Charset)context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());){
            AuthenticationResult authResult = this.databaseProtocolFrontendEngine.getAuthenticationEngine().authenticate(context, payload);
            if (authResult.isFinished()) {
                this.backendConnection.setGrantee(new Grantee(authResult.getUsername(), authResult.getHostname()));
                this.backendConnection.setCurrentSchema(authResult.getDatabase());
            }
            boolean bl = authResult.isFinished();
            return bl;
        }
        catch (Exception ex) {
            log.error("Exception occur: ", (Throwable)ex);
            context.writeAndFlush((Object)this.databaseProtocolFrontendEngine.getCommandExecuteEngine().getErrorPacket(ex, this.backendConnection));
            context.close();
            return false;
        }
    }

    public void channelInactive(ChannelHandlerContext context) {
        context.fireChannelInactive();
        this.closeAllResources();
    }

    private void closeAllResources() {
        ConnectionThreadExecutorGroup.getInstance().unregisterAndAwaitTermination(this.backendConnection.getConnectionId());
        this.backendConnection.closeDatabaseCommunicationEngines(true);
        this.backendConnection.closeConnections(true);
        this.backendConnection.closeFederationExecutor();
        this.databaseProtocolFrontendEngine.release(this.backendConnection);
    }

    public void channelWritabilityChanged(ChannelHandlerContext context) {
        if (context.channel().isWritable()) {
            this.backendConnection.getResourceLock().doNotify();
        }
    }
}

