/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.command;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.packet.CommandPacket;
import org.apache.shardingsphere.db.protocol.packet.CommandPacketType;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.proxy.backend.communication.SQLStatementSchemaHolder;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.ConnectionStatus;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.exception.ExpectedExceptions;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandExecutorTask
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommandExecutorTask.class);
    private final DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine;
    private final BackendConnection backendConnection;
    private final ChannelHandlerContext context;
    private final Object message;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isNeedFlush = false;
        try (PacketPayload payload = this.databaseProtocolFrontendEngine.getCodecEngine().createPacketPayload((ByteBuf)this.message, (Charset)this.context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());){
            ConnectionStatus connectionStatus = this.backendConnection.getConnectionStatus();
            if (!this.backendConnection.getTransactionStatus().isInConnectionHeldTransaction()) {
                connectionStatus.waitUntilConnectionRelease();
                connectionStatus.switchToUsing();
            }
            isNeedFlush = this.executeCommand(this.context, payload, this.backendConnection);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        finally {
            SQLStatementSchemaHolder.remove();
            Collection<SQLException> exceptions = this.closeExecutionResources();
            if (isNeedFlush) {
                this.context.flush();
            }
            if (!this.backendConnection.getTransactionStatus().isInConnectionHeldTransaction()) {
                exceptions.addAll(this.backendConnection.closeDatabaseCommunicationEngines(true));
                exceptions.addAll(this.backendConnection.closeConnections(false));
                this.backendConnection.getConnectionStatus().switchToReleased();
            }
            this.processClosedExceptions(exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCommand(ChannelHandlerContext context, PacketPayload payload, BackendConnection backendConnection) throws SQLException {
        CommandExecuteEngine commandExecuteEngine = this.databaseProtocolFrontendEngine.getCommandExecuteEngine();
        CommandPacketType type = commandExecuteEngine.getCommandPacketType(payload);
        CommandPacket commandPacket = commandExecuteEngine.getCommandPacket(payload, type, backendConnection);
        try (CommandExecutor commandExecutor = commandExecuteEngine.getCommandExecutor(type, commandPacket, backendConnection);){
            Collection responsePackets = commandExecutor.execute();
            if (responsePackets.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            responsePackets.forEach(arg_0 -> ((ChannelHandlerContext)context).write(arg_0));
            if (commandExecutor instanceof QueryCommandExecutor) {
                boolean bl = commandExecuteEngine.writeQueryData(context, backendConnection, (QueryCommandExecutor)commandExecutor, responsePackets.size());
                return bl;
            }
        }
        return this.databaseProtocolFrontendEngine.getFrontendContext().isFlushForPerCommandPacket();
    }

    private void processException(Exception cause) {
        if (!ExpectedExceptions.isExpected(cause.getClass())) {
            log.error("Exception occur: ", (Throwable)cause);
        }
        this.context.write((Object)this.databaseProtocolFrontendEngine.getCommandExecuteEngine().getErrorPacket(cause, this.backendConnection));
        Optional databasePacket = this.databaseProtocolFrontendEngine.getCommandExecuteEngine().getOtherPacket(this.backendConnection);
        databasePacket.ifPresent(arg_0 -> ((ChannelHandlerContext)this.context).write(arg_0));
        this.context.flush();
    }

    private Collection<SQLException> closeExecutionResources() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        result.addAll(this.backendConnection.closeDatabaseCommunicationEngines(false));
        result.addAll(this.backendConnection.closeFederationExecutor());
        return result;
    }

    private void processClosedExceptions(Collection<SQLException> exceptions) {
        if (exceptions.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException("");
        for (SQLException each : exceptions) {
            ex.setNextException(each);
        }
        this.processException(ex);
    }

    @Generated
    public CommandExecutorTask(DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine, BackendConnection backendConnection, ChannelHandlerContext context, Object message) {
        this.databaseProtocolFrontendEngine = databaseProtocolFrontendEngine;
        this.backendConnection = backendConnection;
        this.context = context;
        this.message = message;
    }
}

