/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.api.ScalingClusterAutoSwitchAlgorithm;
import org.apache.shardingsphere.scaling.core.config.HandleConfiguration;
import org.apache.shardingsphere.scaling.core.config.ScalingContext;
import org.apache.shardingsphere.scaling.core.job.position.FinishedPosition;
import org.apache.shardingsphere.scaling.core.job.progress.JobProgress;
import org.apache.shardingsphere.scaling.core.job.task.inventory.InventoryTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScalingTaskUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScalingTaskUtil.class);

    public static boolean almostFinished(Map<Integer, JobProgress> jobProgressMap, HandleConfiguration handleConfig) {
        return ScalingTaskUtil.isProgressCompleted(jobProgressMap, handleConfig) && ScalingTaskUtil.allInventoryTasksFinished(jobProgressMap) && ScalingTaskUtil.allIncrementalTasksAlmostFinished(jobProgressMap);
    }

    private static boolean isProgressCompleted(Map<Integer, JobProgress> jobProgressMap, HandleConfiguration handleConfig) {
        return handleConfig.getShardingTotalCount() == jobProgressMap.size() && jobProgressMap.values().stream().allMatch(Objects::nonNull);
    }

    private static boolean allIncrementalTasksAlmostFinished(Map<Integer, JobProgress> jobProgressMap) {
        long currentTimeMillis = System.currentTimeMillis();
        Collection incrementalTaskIdleMinutes = jobProgressMap.values().stream().flatMap(each -> each.getIncrementalTaskProgressMap().values().stream()).map(each -> {
            long latestActiveTimeMillis = each.getIncrementalTaskDelay().getLatestActiveTimeMillis();
            return latestActiveTimeMillis > 0L ? TimeUnit.MILLISECONDS.toMinutes(currentTimeMillis - latestActiveTimeMillis) : 0L;
        }).collect(Collectors.toList());
        ScalingClusterAutoSwitchAlgorithm clusterAutoSwitchAlgorithm = ScalingContext.getInstance().getClusterAutoSwitchAlgorithm();
        return clusterAutoSwitchAlgorithm.allIncrementalTasksAlmostFinished(incrementalTaskIdleMinutes);
    }

    public static boolean allInventoryTasksFinished(List<InventoryTask> inventoryTasks) {
        if (inventoryTasks.isEmpty()) {
            log.warn("inventoryTasks is empty");
        }
        return inventoryTasks.stream().allMatch(each -> each.getProgress().getPosition() instanceof FinishedPosition);
    }

    private static boolean allInventoryTasksFinished(Map<Integer, JobProgress> jobProgress) {
        return jobProgress.values().stream().flatMap(each -> each.getInventoryTaskProgressMap().values().stream()).allMatch(each -> each.getPosition() instanceof FinishedPosition);
    }

    @Generated
    private ScalingTaskUtil() {
    }
}

