/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.scaling.core.config.DumperConfiguration;
import org.apache.shardingsphere.scaling.core.config.HandleConfiguration;
import org.apache.shardingsphere.scaling.core.config.ImporterConfiguration;
import org.apache.shardingsphere.scaling.core.config.JobConfiguration;
import org.apache.shardingsphere.scaling.core.config.TaskConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.ScalingDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.ShardingSphereJDBCDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.StandardJDBCDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.config.yaml.ShardingRuleConfigurationSwapper;
import org.apache.shardingsphere.sharding.algorithm.keygen.SnowflakeKeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sharding.support.InlineExpressionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobConfigurationUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobConfigurationUtil.class);
    private static final SnowflakeKeyGenerateAlgorithm ID_AUTO_INCREASE_GENERATOR = JobConfigurationUtil.initIdAutoIncreaseGenerator();

    private static SnowflakeKeyGenerateAlgorithm initIdAutoIncreaseGenerator() {
        SnowflakeKeyGenerateAlgorithm result = new SnowflakeKeyGenerateAlgorithm();
        result.init();
        return result;
    }

    private static Long generateKey() {
        return (Long)ID_AUTO_INCREASE_GENERATOR.generateKey();
    }

    public static void fillInProperties(JobConfiguration jobConfig) {
        HandleConfiguration handleConfig = jobConfig.getHandleConfig();
        if (null == handleConfig.getJobId()) {
            handleConfig.setJobId(JobConfigurationUtil.generateKey());
        }
        if (Strings.isNullOrEmpty((String)handleConfig.getDatabaseType())) {
            handleConfig.setDatabaseType(jobConfig.getRuleConfig().getSource().unwrap().getDatabaseType().getName());
        }
        if (null == jobConfig.getHandleConfig().getShardingTables()) {
            Map<String, List<DataNode>> shouldScalingActualDataNodes = JobConfigurationUtil.getShouldScalingActualDataNodes(jobConfig);
            ArrayList<DataNode> dataNodes = new ArrayList<DataNode>();
            for (Map.Entry<String, List<DataNode>> entry : shouldScalingActualDataNodes.entrySet()) {
                dataNodes.addAll((Collection<DataNode>)entry.getValue());
            }
            handleConfig.setShardingTables(JobConfigurationUtil.groupByDataSource(dataNodes));
            handleConfig.setLogicTables(JobConfigurationUtil.getLogicTables(shouldScalingActualDataNodes.keySet()));
        }
    }

    private static Map<String, List<DataNode>> getShouldScalingActualDataNodes(JobConfiguration jobConfig) {
        ScalingDataSourceConfiguration sourceConfig = jobConfig.getRuleConfig().getSource().unwrap();
        Preconditions.checkState((boolean)(sourceConfig instanceof ShardingSphereJDBCDataSourceConfiguration), (Object)"Only ShardingSphereJdbc type of source ScalingDataSourceConfiguration is supported.");
        ShardingSphereJDBCDataSourceConfiguration source = (ShardingSphereJDBCDataSourceConfiguration)sourceConfig;
        ShardingRuleConfiguration sourceRuleConfig = ShardingRuleConfigurationSwapper.findAndConvertShardingRuleConfiguration(source.getRootConfig().getRules());
        ShardingRule shardingRule = new ShardingRule(sourceRuleConfig, source.getRootConfig().getDataSources().keySet());
        Map tableRules = shardingRule.getTableRules();
        LinkedHashMap<String, List<DataNode>> result = new LinkedHashMap<String, List<DataNode>>();
        for (Map.Entry entry : tableRules.entrySet()) {
            result.put((String)entry.getKey(), ((TableRule)entry.getValue()).getActualDataNodes());
        }
        return result;
    }

    private static String[] groupByDataSource(Collection<DataNode> dataNodes) {
        LinkedHashMap<String, Collection> dataSourceDataNodesMap = new LinkedHashMap<String, Collection>();
        for (DataNode each2 : dataNodes) {
            dataSourceDataNodesMap.computeIfAbsent(each2.getDataSourceName(), k -> new LinkedList()).add(each2);
        }
        return (String[])dataSourceDataNodesMap.values().stream().map(each -> each.stream().map(dataNode -> String.format("%s.%s", dataNode.getDataSourceName(), dataNode.getTableName())).collect(Collectors.joining(","))).toArray(String[]::new);
    }

    private static String getLogicTables(Set<String> logicTables) {
        return logicTables.stream().reduce((a, b) -> String.format("%s, %s", a, b)).orElse("");
    }

    public static List<TaskConfiguration> toTaskConfigs(JobConfiguration jobConfig) {
        LinkedList<TaskConfiguration> result = new LinkedList<TaskConfiguration>();
        ShardingSphereJDBCDataSourceConfiguration sourceConfig = JobConfigurationUtil.getSourceConfiguration(jobConfig);
        ShardingRuleConfiguration sourceRuleConfig = ShardingRuleConfigurationSwapper.findAndConvertShardingRuleConfiguration(sourceConfig.getRootConfig().getRules());
        Map<String, DataSourceConfiguration> sourceDataSource = JobConfigurationUtil.getDataSourceConfigurations(sourceConfig.getRootConfig());
        Map<String, Map<String, String>> dataSourceTableNameMap = JobConfigurationUtil.toDataSourceTableNameMap(new ShardingRule(sourceRuleConfig, sourceConfig.getRootConfig().getDataSources().keySet()));
        Optional<ShardingRuleConfiguration> targetRuleConfig = JobConfigurationUtil.getTargetRuleConfiguration(jobConfig);
        JobConfigurationUtil.filterByShardingDataSourceTables(dataSourceTableNameMap, jobConfig.getHandleConfig());
        Map<String, Set<String>> shardingColumnsMap = JobConfigurationUtil.getShardingColumnsMap(targetRuleConfig.orElse(sourceRuleConfig));
        for (Map.Entry<String, Map<String, String>> entry : dataSourceTableNameMap.entrySet()) {
            DumperConfiguration dumperConfig = JobConfigurationUtil.createDumperConfig(entry.getKey(), sourceDataSource.get(entry.getKey()).getProps(), entry.getValue());
            ImporterConfiguration importerConfig = JobConfigurationUtil.createImporterConfig(jobConfig, shardingColumnsMap);
            TaskConfiguration taskConfig = new TaskConfiguration(jobConfig.getHandleConfig(), dumperConfig, importerConfig);
            log.info("toTaskConfigs, dataSourceName={}, taskConfig={}", (Object)entry.getKey(), (Object)taskConfig);
            result.add(taskConfig);
        }
        return result;
    }

    private static ShardingSphereJDBCDataSourceConfiguration getSourceConfiguration(JobConfiguration jobConfig) {
        ScalingDataSourceConfiguration result = jobConfig.getRuleConfig().getSource().unwrap();
        Preconditions.checkArgument((boolean)(result instanceof ShardingSphereJDBCDataSourceConfiguration), (Object)"Only support ShardingSphere source data source.");
        return (ShardingSphereJDBCDataSourceConfiguration)result;
    }

    public static Map<String, DataSourceConfiguration> getDataSourceConfigurations(YamlRootConfiguration yamlRootConfiguration) {
        Map yamlDataSourceConfigs = yamlRootConfiguration.getDataSources();
        LinkedHashMap<String, DataSourceConfiguration> result = new LinkedHashMap<String, DataSourceConfiguration>(yamlDataSourceConfigs.size());
        yamlDataSourceConfigs.forEach((key, value) -> result.put((String)key, new YamlDataSourceConfigurationSwapper().swapToDataSourceConfiguration(value)));
        return result;
    }

    private static Optional<ShardingRuleConfiguration> getTargetRuleConfiguration(JobConfiguration jobConfig) {
        ScalingDataSourceConfiguration dataSourceConfig = jobConfig.getRuleConfig().getTarget().unwrap();
        if (dataSourceConfig instanceof ShardingSphereJDBCDataSourceConfiguration) {
            return Optional.of(ShardingRuleConfigurationSwapper.findAndConvertShardingRuleConfiguration(((ShardingSphereJDBCDataSourceConfiguration)dataSourceConfig).getRootConfig().getRules()));
        }
        return Optional.empty();
    }

    private static void filterByShardingDataSourceTables(Map<String, Map<String, String>> dataSourceTableNameMap, HandleConfiguration handleConfig) {
        if (null == handleConfig.getShardingTables()) {
            log.info("shardingTables null");
            return;
        }
        Map<String, Set<String>> shardingDataSourceTableMap = JobConfigurationUtil.toDataSourceTableNameMap(JobConfigurationUtil.getShardingDataSourceTables(handleConfig));
        dataSourceTableNameMap.entrySet().removeIf(entry -> !shardingDataSourceTableMap.containsKey(entry.getKey()));
        for (Map.Entry<String, Map<String, String>> entry2 : dataSourceTableNameMap.entrySet()) {
            JobConfigurationUtil.filterByShardingTables(entry2.getValue(), shardingDataSourceTableMap.get(entry2.getKey()));
        }
    }

    private static String getShardingDataSourceTables(HandleConfiguration handleConfig) {
        if (handleConfig.getShardingItem() >= handleConfig.getShardingTables().length) {
            log.warn("shardingItem={} ge handleConfig.shardingTables.len={}", (Object)handleConfig.getShardingItem(), (Object)handleConfig.getShardingTables().length);
            return "";
        }
        return handleConfig.getShardingTables()[handleConfig.getShardingItem()];
    }

    private static void filterByShardingTables(Map<String, String> fullTables, Set<String> shardingTables) {
        fullTables.entrySet().removeIf(entry -> !shardingTables.contains(entry.getKey()));
    }

    private static Map<String, Set<String>> toDataSourceTableNameMap(String shardingDataSourceTables) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String each : new InlineExpressionParser(shardingDataSourceTables).splitAndEvaluate()) {
            String[] table = each.split("\\.");
            if (!result.containsKey(table[0])) {
                result.put(table[0], new HashSet());
            }
            ((Set)result.get(table[0])).add(table[1]);
        }
        return result;
    }

    private static Map<String, Map<String, String>> toDataSourceTableNameMap(ShardingRule shardingRule) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (TableRule each : shardingRule.getTableRules().values()) {
            JobConfigurationUtil.mergeDataSourceTableNameMap(result, JobConfigurationUtil.toDataSourceTableNameMap(each));
        }
        return result;
    }

    private static Map<String, Map<String, String>> toDataSourceTableNameMap(TableRule tableRule) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Map.Entry entry : tableRule.getDatasourceToTablesMap().entrySet()) {
            Map tableNameMap = (Map)result.get(entry.getKey());
            if (null == tableNameMap) {
                result.put((String)entry.getKey(), JobConfigurationUtil.toTableNameMap(tableRule.getLogicTable(), (Collection)entry.getValue()));
                continue;
            }
            tableNameMap.putAll(JobConfigurationUtil.toTableNameMap(tableRule.getLogicTable(), (Collection)entry.getValue()));
        }
        return result;
    }

    private static Map<String, String> toTableNameMap(String logicalTable, Collection<String> actualTables) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String each : actualTables) {
            result.put(each, logicalTable);
        }
        return result;
    }

    private static void mergeDataSourceTableNameMap(Map<String, Map<String, String>> mergedResult, Map<String, Map<String, String>> newDataSourceTableNameMap) {
        for (Map.Entry<String, Map<String, String>> entry : newDataSourceTableNameMap.entrySet()) {
            Map<String, String> tableNameMap = mergedResult.get(entry.getKey());
            if (null == tableNameMap) {
                mergedResult.put(entry.getKey(), entry.getValue());
                continue;
            }
            tableNameMap.putAll(entry.getValue());
        }
    }

    private static Map<String, Set<String>> getShardingColumnsMap(ShardingRuleConfiguration shardingRuleConfig) {
        Set<String> defaultDatabaseShardingColumns = JobConfigurationUtil.extractShardingColumns(shardingRuleConfig.getDefaultDatabaseShardingStrategy());
        Set<String> defaultTableShardingColumns = JobConfigurationUtil.extractShardingColumns(shardingRuleConfig.getDefaultTableShardingStrategy());
        ConcurrentMap result = Maps.newConcurrentMap();
        for (ShardingTableRuleConfiguration each : shardingRuleConfig.getTables()) {
            HashSet<String> shardingColumns = new HashSet<String>();
            shardingColumns.addAll(null == each.getDatabaseShardingStrategy() ? defaultDatabaseShardingColumns : JobConfigurationUtil.extractShardingColumns(each.getDatabaseShardingStrategy()));
            shardingColumns.addAll(null == each.getTableShardingStrategy() ? defaultTableShardingColumns : JobConfigurationUtil.extractShardingColumns(each.getTableShardingStrategy()));
            result.put(each.getLogicTable(), shardingColumns);
        }
        for (ShardingTableRuleConfiguration each : shardingRuleConfig.getAutoTables()) {
            ShardingStrategyConfiguration shardingStrategy = each.getShardingStrategy();
            HashSet<String> shardingColumns = new HashSet<String>(JobConfigurationUtil.extractShardingColumns(shardingStrategy));
            result.put(each.getLogicTable(), shardingColumns);
        }
        return result;
    }

    private static Set<String> extractShardingColumns(ShardingStrategyConfiguration shardingStrategy) {
        if (shardingStrategy instanceof StandardShardingStrategyConfiguration) {
            return Sets.newHashSet((Object[])new String[]{((StandardShardingStrategyConfiguration)shardingStrategy).getShardingColumn()});
        }
        if (shardingStrategy instanceof ComplexShardingStrategyConfiguration) {
            return Sets.newHashSet((Object[])((ComplexShardingStrategyConfiguration)shardingStrategy).getShardingColumns().split(","));
        }
        return Collections.emptySet();
    }

    private static DumperConfiguration createDumperConfig(String dataSourceName, Map<String, Object> props, Map<String, String> tableMap) {
        DumperConfiguration result = new DumperConfiguration();
        result.setDataSourceName(dataSourceName);
        result.setDataSourceConfig(new StandardJDBCDataSourceConfiguration(YamlEngine.marshal(props)));
        result.setTableNameMap(tableMap);
        return result;
    }

    private static ImporterConfiguration createImporterConfig(JobConfiguration jobConfig, Map<String, Set<String>> shardingColumnsMap) {
        ImporterConfiguration result = new ImporterConfiguration();
        result.setDataSourceConfig(jobConfig.getRuleConfig().getTarget().unwrap());
        result.setShardingColumnsMap(shardingColumnsMap);
        result.setRetryTimes(jobConfig.getHandleConfig().getRetryTimes());
        return result;
    }

    @Generated
    private JobConfigurationUtil() {
    }
}

