/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.util;

import com.google.common.base.Preconditions;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.datasource.JdbcUri;
import org.apache.shardingsphere.scaling.core.config.datasource.ScalingDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.ShardingSphereJDBCDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.StandardJDBCDataSourceConfiguration;

public final class JDBCUtil {
    public static void appendJDBCParameter(ScalingDataSourceConfiguration scalingDataSourceConfiguration, Map<String, String> parameters) {
        if (scalingDataSourceConfiguration instanceof StandardJDBCDataSourceConfiguration) {
            JDBCUtil.append((StandardJDBCDataSourceConfiguration)scalingDataSourceConfiguration, parameters);
        } else if (scalingDataSourceConfiguration instanceof ShardingSphereJDBCDataSourceConfiguration) {
            JDBCUtil.append((ShardingSphereJDBCDataSourceConfiguration)scalingDataSourceConfiguration, parameters);
        }
    }

    public static String appendJDBCParameter(String jdbcUrl, Map<String, String> parameters) {
        return JDBCUtil.append(jdbcUrl, parameters);
    }

    private static void append(StandardJDBCDataSourceConfiguration dataSourceConfig, Map<String, String> parameters) {
        dataSourceConfig.getHikariConfig().setJdbcUrl(JDBCUtil.append(dataSourceConfig.getHikariConfig().getJdbcUrl(), parameters));
    }

    private static void append(ShardingSphereJDBCDataSourceConfiguration dataSourceConfig, Map<String, String> parameters) {
        dataSourceConfig.getRootConfig().getDataSources().forEach((key, value) -> {
            String jdbcUrlKey = value.containsKey("url") ? "url" : "jdbcUrl";
            value.replace(jdbcUrlKey, JDBCUtil.append(value.get(jdbcUrlKey).toString(), parameters));
        });
    }

    private static String append(String url, Map<String, String> parameters) {
        JdbcUri uri = new JdbcUri(url);
        return String.format("jdbc:%s://%s/%s?%s", uri.getScheme(), uri.getHost(), uri.getDatabase(), JDBCUtil.mergeParameters(uri.getParameters(), parameters));
    }

    private static String mergeParameters(Map<String, String> parameters, Map<String, String> appendParameters) {
        parameters.putAll(appendParameters);
        return JDBCUtil.formatParameters(parameters);
    }

    private static String formatParameters(Map<String, String> parameters) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            result.append(entry.getKey());
            if (null != entry.getValue()) {
                result.append("=").append(entry.getValue());
            }
            result.append("&");
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static String getJdbcUrl(Map<String, Object> parameters) {
        Object result = parameters.getOrDefault("url", parameters.get("jdbcUrl"));
        Preconditions.checkNotNull((Object)result, (Object)"url or jdbcUrl is required.");
        return result.toString();
    }

    @Generated
    private JDBCUtil() {
    }
}

