/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.spi;

import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.spi.ScalingEntry;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;

public final class ScalingEntryLoader {
    private static final Map<String, ScalingEntry> SCALING_ENTRY_MAP = new TreeMap<String, ScalingEntry>(String.CASE_INSENSITIVE_ORDER);

    public static ScalingEntry getInstance(String databaseType) {
        if (SCALING_ENTRY_MAP.containsKey(databaseType)) {
            return SCALING_ENTRY_MAP.get(databaseType);
        }
        throw new UnsupportedOperationException(String.format("Unsupported database type '%s'", databaseType));
    }

    @Generated
    private ScalingEntryLoader() {
    }

    static {
        ShardingSphereServiceLoader.register(ScalingEntry.class);
        for (ScalingEntry each : ShardingSphereServiceLoader.getSingletonServiceInstances(ScalingEntry.class)) {
            SCALING_ENTRY_MAP.put(each.getDatabaseType(), each);
        }
    }
}

