/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.task.inventory;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.channel.MemoryChannel;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceManager;
import org.apache.shardingsphere.scaling.core.common.exception.ScalingTaskExecuteException;
import org.apache.shardingsphere.scaling.core.common.record.Record;
import org.apache.shardingsphere.scaling.core.config.ImporterConfiguration;
import org.apache.shardingsphere.scaling.core.config.InventoryDumperConfiguration;
import org.apache.shardingsphere.scaling.core.config.ScalingContext;
import org.apache.shardingsphere.scaling.core.executor.AbstractScalingExecutor;
import org.apache.shardingsphere.scaling.core.executor.dumper.Dumper;
import org.apache.shardingsphere.scaling.core.executor.dumper.DumperFactory;
import org.apache.shardingsphere.scaling.core.executor.engine.ExecuteCallback;
import org.apache.shardingsphere.scaling.core.executor.importer.Importer;
import org.apache.shardingsphere.scaling.core.executor.importer.ImporterFactory;
import org.apache.shardingsphere.scaling.core.job.position.PlaceholderPosition;
import org.apache.shardingsphere.scaling.core.job.position.ScalingPosition;
import org.apache.shardingsphere.scaling.core.job.task.ScalingTask;
import org.apache.shardingsphere.scaling.core.job.task.inventory.InventoryTaskProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryTask
extends AbstractScalingExecutor
implements ScalingTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryTask.class);
    private final String taskId;
    private final InventoryDumperConfiguration inventoryDumperConfig;
    private final ImporterConfiguration importerConfig;
    private final DataSourceManager dataSourceManager;
    private Dumper dumper;
    private ScalingPosition<?> position;

    public InventoryTask(InventoryDumperConfiguration inventoryDumperConfig, ImporterConfiguration importerConfig) {
        this(inventoryDumperConfig, importerConfig, new DataSourceManager());
    }

    public InventoryTask(InventoryDumperConfiguration inventoryDumperConfig, ImporterConfiguration importerConfig, DataSourceManager dataSourceManager) {
        this.inventoryDumperConfig = inventoryDumperConfig;
        this.importerConfig = importerConfig;
        this.dataSourceManager = dataSourceManager;
        this.taskId = this.generateTaskId(inventoryDumperConfig);
        this.position = inventoryDumperConfig.getPosition();
    }

    private String generateTaskId(InventoryDumperConfiguration inventoryDumperConfig) {
        String result = String.format("%s.%s", inventoryDumperConfig.getDataSourceName(), inventoryDumperConfig.getTableName());
        return null == inventoryDumperConfig.getShardingItem() ? result : result + "#" + inventoryDumperConfig.getShardingItem();
    }

    @Override
    public void start() {
        this.instanceDumper();
        Importer importer = ImporterFactory.newInstance(this.importerConfig, this.dataSourceManager);
        this.instanceChannel(importer);
        Future<?> future = ScalingContext.getInstance().getImporterExecuteEngine().submit(importer, new ExecuteCallback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure(Throwable throwable) {
                log.error("get an error when migrating the inventory data", throwable);
                InventoryTask.this.dumper.stop();
            }
        });
        this.dumper.start();
        this.waitForResult(future);
        this.dataSourceManager.close();
    }

    private void instanceDumper() {
        this.dumper = DumperFactory.newInstanceJdbcDumper(this.inventoryDumperConfig, this.dataSourceManager);
    }

    private void instanceChannel(Importer importer) {
        MemoryChannel channel = new MemoryChannel(records -> {
            Optional<Record> record = records.stream().filter(each -> !(each.getPosition() instanceof PlaceholderPosition)).reduce((a, b) -> b);
            record.ifPresent(value -> {
                this.position = value.getPosition();
            });
        });
        this.dumper.setChannel(channel);
        importer.setChannel(channel);
    }

    private void waitForResult(Future<?> future) {
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException ex) {
            throw new ScalingTaskExecuteException(String.format("Task %s execute failed ", this.taskId), ex.getCause());
        }
    }

    @Override
    public void stop() {
        if (null != this.dumper) {
            this.dumper.stop();
            this.dumper = null;
        }
    }

    @Override
    public InventoryTaskProgress getProgress() {
        return new InventoryTaskProgress(this.position);
    }

    @Override
    @Generated
    public String getTaskId() {
        return this.taskId;
    }
}

