/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.task.incremental;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.channel.distribution.DistributionChannel;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceManager;
import org.apache.shardingsphere.scaling.core.common.exception.ScalingTaskExecuteException;
import org.apache.shardingsphere.scaling.core.common.record.Record;
import org.apache.shardingsphere.scaling.core.config.DumperConfiguration;
import org.apache.shardingsphere.scaling.core.config.ImporterConfiguration;
import org.apache.shardingsphere.scaling.core.config.ScalingContext;
import org.apache.shardingsphere.scaling.core.executor.AbstractScalingExecutor;
import org.apache.shardingsphere.scaling.core.executor.dumper.Dumper;
import org.apache.shardingsphere.scaling.core.executor.dumper.DumperFactory;
import org.apache.shardingsphere.scaling.core.executor.engine.ExecuteCallback;
import org.apache.shardingsphere.scaling.core.executor.importer.Importer;
import org.apache.shardingsphere.scaling.core.executor.importer.ImporterFactory;
import org.apache.shardingsphere.scaling.core.executor.importer.ImporterListener;
import org.apache.shardingsphere.scaling.core.job.position.PlaceholderPosition;
import org.apache.shardingsphere.scaling.core.job.task.ScalingTask;
import org.apache.shardingsphere.scaling.core.job.task.incremental.IncrementalTaskProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncrementalTask
extends AbstractScalingExecutor
implements ScalingTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IncrementalTask.class);
    private final String taskId;
    private final int concurrency;
    private final DumperConfiguration dumperConfig;
    private final ImporterConfiguration importerConfig;
    private final DataSourceManager dataSourceManager;
    private Dumper dumper;
    private final IncrementalTaskProgress progress;

    public IncrementalTask(int concurrency, DumperConfiguration dumperConfig, ImporterConfiguration importerConfig) {
        this.concurrency = concurrency;
        this.dumperConfig = dumperConfig;
        this.importerConfig = importerConfig;
        this.dataSourceManager = new DataSourceManager();
        this.taskId = dumperConfig.getDataSourceName();
        this.progress = new IncrementalTaskProgress();
        this.progress.setPosition(dumperConfig.getPosition());
    }

    @Override
    public void start() {
        this.progress.getIncrementalTaskDelay().setLatestActiveTimeMillis(System.currentTimeMillis());
        this.dumper = DumperFactory.newInstanceLogDumper(this.dumperConfig, this.progress.getPosition());
        List<Importer> importers = this.instanceImporters();
        this.instanceChannel(importers);
        Future<?> future = ScalingContext.getInstance().getIncrementalDumperExecuteEngine().submitAll(importers, this.getExecuteCallback());
        this.dumper.start();
        this.waitForResult(future);
        this.dataSourceManager.close();
    }

    private List<Importer> instanceImporters() {
        ArrayList<Importer> result = new ArrayList<Importer>(this.concurrency);
        for (int i = 0; i < this.concurrency; ++i) {
            result.add(ImporterFactory.newInstance(this.importerConfig, this.dataSourceManager));
        }
        return result;
    }

    private void instanceChannel(Collection<Importer> importers) {
        DistributionChannel channel = new DistributionChannel(importers.size(), records -> {
            Record lastHandledRecord = (Record)records.get(records.size() - 1);
            if (!(lastHandledRecord.getPosition() instanceof PlaceholderPosition)) {
                this.progress.setPosition(lastHandledRecord.getPosition());
                this.progress.getIncrementalTaskDelay().setLastEventTimestamps(lastHandledRecord.getCommitTime());
            }
        });
        this.dumper.setChannel(channel);
        ImporterListener importerListener = records -> this.progress.getIncrementalTaskDelay().setLatestActiveTimeMillis(System.currentTimeMillis());
        for (Importer each : importers) {
            each.setChannel(channel);
            each.setImporterListener(importerListener);
        }
    }

    private ExecuteCallback getExecuteCallback() {
        return new ExecuteCallback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure(Throwable throwable) {
                log.error("get an error when migrating the increment data", throwable);
                IncrementalTask.this.dumper.stop();
            }
        };
    }

    private void waitForResult(Future<?> future) {
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException ex) {
            throw new ScalingTaskExecuteException(String.format("Task %s execute failed ", this.taskId), ex.getCause());
        }
    }

    @Override
    public void stop() {
        if (null != this.dumper) {
            this.dumper.stop();
            this.dumper = null;
        }
    }

    @Override
    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    @Generated
    public IncrementalTaskProgress getProgress() {
        return this.progress;
    }
}

