/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.schedule;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;
import org.apache.shardingsphere.scaling.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.scaling.core.api.ScalingAPIFactory;
import org.apache.shardingsphere.scaling.core.job.JobContext;
import org.apache.shardingsphere.scaling.core.job.schedule.JobScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobSchedulerCenter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobSchedulerCenter.class);
    private static final Map<Long, Map<Integer, JobScheduler>> JOB_SCHEDULER_MAP = Maps.newConcurrentMap();
    private static final ScheduledExecutorService JOB_PERSIST_EXECUTOR = Executors.newSingleThreadScheduledExecutor(ExecutorThreadFactoryBuilder.build((String)"scaling-job-persist-%d"));
    private static final GovernanceRepositoryAPI REGISTRY_REPOSITORY_API = ScalingAPIFactory.getGovernanceRepositoryAPI();

    public static void start(JobContext jobContext) {
        int shardingItem;
        long jobId = jobContext.getJobId();
        Map schedulerMap = JOB_SCHEDULER_MAP.computeIfAbsent(jobId, key -> Maps.newConcurrentMap());
        if (schedulerMap.containsKey(shardingItem = jobContext.getShardingItem())) {
            log.warn("schedulerMap does not contain shardingItem {}, ignore", (Object)shardingItem);
            return;
        }
        log.info("start JobScheduler, jobId={}, shardingItem={}", (Object)jobId, (Object)shardingItem);
        JobScheduler jobScheduler = new JobScheduler(jobContext);
        jobScheduler.start();
        schedulerMap.put(shardingItem, jobScheduler);
    }

    public static void stop(long jobId) {
        Map<Integer, JobScheduler> schedulerMap = JOB_SCHEDULER_MAP.remove(jobId);
        if (null == schedulerMap) {
            return;
        }
        for (Map.Entry<Integer, JobScheduler> entry : schedulerMap.entrySet()) {
            entry.getValue().stop();
        }
    }

    public static Optional<Collection<JobContext>> getJobContexts(long jobId) {
        Map<Integer, JobScheduler> schedulerMap = JOB_SCHEDULER_MAP.get(jobId);
        if (null == schedulerMap) {
            return Optional.empty();
        }
        return Optional.of(schedulerMap.values().stream().map(JobScheduler::getJobContext).collect(Collectors.toList()));
    }

    public static void persistJobProgress(JobContext jobContext) {
        REGISTRY_REPOSITORY_API.persistJobProgress(jobContext);
    }

    @Generated
    private JobSchedulerCenter() {
    }

    static {
        JOB_PERSIST_EXECUTOR.scheduleWithFixedDelay(new PersistJobContextRunnable(), 1L, 1L, TimeUnit.MINUTES);
    }

    private static final class PersistJobContextRunnable
    implements Runnable {
        private PersistJobContextRunnable() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : JOB_SCHEDULER_MAP.entrySet()) {
                try {
                    ((Map)entry.getValue()).forEach((shardingItem, jobScheduler) -> REGISTRY_REPOSITORY_API.persistJobProgress(jobScheduler.getJobContext()));
                }
                catch (Exception ex) {
                    log.error("persist job {} context failed.", entry.getKey(), (Object)ex);
                }
            }
        }
    }
}

