/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.schedule;

import lombok.Generated;
import org.apache.shardingsphere.scaling.core.config.ScalingContext;
import org.apache.shardingsphere.scaling.core.executor.engine.ExecuteCallback;
import org.apache.shardingsphere.scaling.core.job.JobContext;
import org.apache.shardingsphere.scaling.core.job.JobStatus;
import org.apache.shardingsphere.scaling.core.job.preparer.ScalingJobPreparer;
import org.apache.shardingsphere.scaling.core.job.task.ScalingTask;
import org.apache.shardingsphere.scaling.core.util.ScalingTaskUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobScheduler
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobScheduler.class);
    private final JobContext jobContext;

    public void start() {
        new Thread(this).start();
    }

    public void stop() {
        log.info("stop scaling job {}", (Object)this.jobContext.getJobId());
        boolean almostFinished = this.jobContext.getStatus() == JobStatus.ALMOST_FINISHED;
        for (ScalingTask scalingTask : this.jobContext.getInventoryTasks()) {
            log.info("stop inventory task {} - {}", (Object)this.jobContext.getJobId(), (Object)scalingTask.getTaskId());
            scalingTask.stop();
        }
        for (ScalingTask scalingTask : this.jobContext.getIncrementalTasks()) {
            log.info("stop incremental task {} - {}", (Object)this.jobContext.getJobId(), (Object)scalingTask.getTaskId());
            scalingTask.stop();
        }
        if (almostFinished) {
            log.info("almost finished, preparer cleanup, job {}", (Object)this.jobContext.getJobId());
            ScalingJobPreparer jobPreparer = this.jobContext.getJobPreparer();
            if (null != jobPreparer) {
                jobPreparer.cleanup(this.jobContext);
            }
        }
    }

    @Override
    public void run() {
        if (this.executeInventoryTask()) {
            this.executeIncrementalTask();
        }
    }

    private synchronized boolean executeInventoryTask() {
        if (ScalingTaskUtil.allInventoryTasksFinished(this.jobContext.getInventoryTasks())) {
            log.info("All inventory tasks finished.");
            return true;
        }
        log.info("-------------- Start inventory task --------------");
        this.jobContext.setStatus(JobStatus.EXECUTE_INVENTORY_TASK);
        ExecuteCallback inventoryTaskCallback = this.createInventoryTaskCallback();
        for (ScalingTask scalingTask : this.jobContext.getInventoryTasks()) {
            ScalingContext.getInstance().getInventoryDumperExecuteEngine().submit(scalingTask, inventoryTaskCallback);
        }
        return false;
    }

    private ExecuteCallback createInventoryTaskCallback() {
        return new ExecuteCallback(){

            @Override
            public void onSuccess() {
                if (ScalingTaskUtil.allInventoryTasksFinished(JobScheduler.this.jobContext.getInventoryTasks())) {
                    log.info("All inventory tasks finished.");
                    JobScheduler.this.executeIncrementalTask();
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                log.error("Inventory task execute failed.", throwable);
                JobScheduler.this.stop();
                JobScheduler.this.jobContext.setStatus(JobStatus.EXECUTE_INVENTORY_TASK_FAILURE);
            }
        };
    }

    private synchronized void executeIncrementalTask() {
        if (JobStatus.EXECUTE_INCREMENTAL_TASK == this.jobContext.getStatus()) {
            log.info("job status already EXECUTE_INCREMENTAL_TASK, ignore");
            return;
        }
        log.info("-------------- Start incremental task --------------");
        this.jobContext.setStatus(JobStatus.EXECUTE_INCREMENTAL_TASK);
        ExecuteCallback incrementalTaskCallback = this.createIncrementalTaskCallback();
        for (ScalingTask scalingTask : this.jobContext.getIncrementalTasks()) {
            ScalingContext.getInstance().getIncrementalDumperExecuteEngine().submit(scalingTask, incrementalTaskCallback);
        }
    }

    private ExecuteCallback createIncrementalTaskCallback() {
        return new ExecuteCallback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure(Throwable throwable) {
                log.error("Incremental task execute failed.", throwable);
                JobScheduler.this.stop();
                JobScheduler.this.jobContext.setStatus(JobStatus.EXECUTE_INCREMENTAL_TASK_FAILURE);
            }
        };
    }

    @Generated
    public JobScheduler(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    @Generated
    public JobContext getJobContext() {
        return this.jobContext;
    }
}

