/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.progress.yaml;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shardingsphere.scaling.core.job.JobStatus;
import org.apache.shardingsphere.scaling.core.job.position.FinishedPosition;
import org.apache.shardingsphere.scaling.core.job.position.PlaceholderPosition;
import org.apache.shardingsphere.scaling.core.job.position.PositionInitializerFactory;
import org.apache.shardingsphere.scaling.core.job.position.PrimaryKeyPosition;
import org.apache.shardingsphere.scaling.core.job.progress.JobProgress;
import org.apache.shardingsphere.scaling.core.job.progress.yaml.YamlJobProgress;
import org.apache.shardingsphere.scaling.core.job.task.incremental.IncrementalTaskProgress;
import org.apache.shardingsphere.scaling.core.job.task.inventory.InventoryTaskProgress;

public final class JobProgressYamlSwapper {
    public YamlJobProgress swapToYaml(JobProgress jobProgress) {
        YamlJobProgress result = new YamlJobProgress();
        result.setStatus(jobProgress.getStatus().name());
        result.setDatabaseType(jobProgress.getDatabaseType());
        result.setInventory(this.getYamlInventory(jobProgress.getInventoryTaskProgressMap()));
        result.setIncremental(this.getYamlIncremental(jobProgress.getIncrementalTaskProgressMap()));
        return result;
    }

    private YamlJobProgress.YamlInventory getYamlInventory(Map<String, InventoryTaskProgress> inventoryTaskProgressMap) {
        YamlJobProgress.YamlInventory result = new YamlJobProgress.YamlInventory();
        result.setFinished(this.getFinished(inventoryTaskProgressMap));
        result.setUnfinished(this.getUnfinished(inventoryTaskProgressMap));
        return result;
    }

    private String[] getFinished(Map<String, InventoryTaskProgress> inventoryTaskProgressMap) {
        return (String[])inventoryTaskProgressMap.entrySet().stream().filter(entry -> ((InventoryTaskProgress)entry.getValue()).getPosition() instanceof FinishedPosition).map(Map.Entry::getKey).toArray(String[]::new);
    }

    private Map<String, String> getUnfinished(Map<String, InventoryTaskProgress> inventoryTaskProgressMap) {
        return inventoryTaskProgressMap.entrySet().stream().filter(entry -> !(((InventoryTaskProgress)entry.getValue()).getPosition() instanceof FinishedPosition)).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((InventoryTaskProgress)entry.getValue()).getPosition().toString()));
    }

    private Map<String, YamlJobProgress.YamlIncremental> getYamlIncremental(Map<String, IncrementalTaskProgress> incrementalTaskProgressMap) {
        return incrementalTaskProgressMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            YamlJobProgress.YamlIncremental result = new YamlJobProgress.YamlIncremental();
            result.setPosition(((IncrementalTaskProgress)entry.getValue()).getPosition().toString());
            result.setDelay(((IncrementalTaskProgress)entry.getValue()).getIncrementalTaskDelay());
            return result;
        }));
    }

    public JobProgress swapToObject(YamlJobProgress yamlJobProgress) {
        JobProgress result = new JobProgress();
        result.setStatus(JobStatus.valueOf(yamlJobProgress.getStatus()));
        result.setDatabaseType(yamlJobProgress.getDatabaseType());
        result.setInventoryTaskProgressMap(this.getInventoryTaskProgressMap(yamlJobProgress.getInventory()));
        result.setIncrementalTaskProgressMap(this.getIncrementalTaskProgressMap(yamlJobProgress.getDatabaseType(), yamlJobProgress.getIncremental()));
        return result;
    }

    private Map<String, InventoryTaskProgress> getInventoryTaskProgressMap(YamlJobProgress.YamlInventory inventory) {
        if (null == inventory) {
            return new LinkedHashMap<String, InventoryTaskProgress>();
        }
        HashMap<String, InventoryTaskProgress> result = new HashMap<String, InventoryTaskProgress>();
        result.putAll(Arrays.stream(inventory.getFinished()).collect(Collectors.toMap(each -> each, each -> new InventoryTaskProgress(new FinishedPosition()))));
        result.putAll(inventory.getUnfinished().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this.getInventoryTaskProgressFunction())));
        return result;
    }

    private Function<Map.Entry<String, String>, InventoryTaskProgress> getInventoryTaskProgressFunction() {
        return entry -> new InventoryTaskProgress(Strings.isNullOrEmpty((String)((String)entry.getValue())) ? new PlaceholderPosition() : PrimaryKeyPosition.init((String)entry.getValue()));
    }

    private Map<String, IncrementalTaskProgress> getIncrementalTaskProgressMap(String databaseType, Map<String, YamlJobProgress.YamlIncremental> incremental) {
        if (null == incremental) {
            return new LinkedHashMap<String, IncrementalTaskProgress>();
        }
        return incremental.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this.getIncrementalTaskProgressFunction(databaseType)));
    }

    private Function<Map.Entry<String, YamlJobProgress.YamlIncremental>, IncrementalTaskProgress> getIncrementalTaskProgressFunction(String databaseType) {
        return entry -> new IncrementalTaskProgress(PositionInitializerFactory.newInstance(databaseType).init(((YamlJobProgress.YamlIncremental)entry.getValue()).getPosition()), ((YamlJobProgress.YamlIncremental)entry.getValue()).getDelay());
    }
}

