/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.progress;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.scaling.core.job.JobStatus;
import org.apache.shardingsphere.scaling.core.job.position.FinishedPosition;
import org.apache.shardingsphere.scaling.core.job.position.ScalingPosition;
import org.apache.shardingsphere.scaling.core.job.progress.yaml.JobProgressYamlSwapper;
import org.apache.shardingsphere.scaling.core.job.progress.yaml.YamlJobProgress;
import org.apache.shardingsphere.scaling.core.job.task.incremental.IncrementalTaskProgress;
import org.apache.shardingsphere.scaling.core.job.task.inventory.InventoryTaskProgress;

public final class JobProgress {
    private static final JobProgressYamlSwapper JOB_PROGRESS_YAML_SWAPPER = new JobProgressYamlSwapper();
    private JobStatus status = JobStatus.RUNNING;
    private String databaseType;
    private Map<String, InventoryTaskProgress> inventoryTaskProgressMap;
    private Map<String, IncrementalTaskProgress> incrementalTaskProgressMap;

    public static JobProgress init(String data) {
        return JOB_PROGRESS_YAML_SWAPPER.swapToObject((YamlJobProgress)YamlEngine.unmarshal((String)data, YamlJobProgress.class));
    }

    public Optional<ScalingPosition<?>> getIncrementalPosition(String dataSourceName) {
        IncrementalTaskProgress progress = this.incrementalTaskProgressMap.get(dataSourceName);
        return Optional.ofNullable(null != progress ? progress.getPosition() : null);
    }

    public Map<String, ScalingPosition<?>> getInventoryPosition(String tableName) {
        Pattern pattern = Pattern.compile(String.format("%s(#\\d+)?", tableName));
        return this.inventoryTaskProgressMap.entrySet().stream().filter(entry -> pattern.matcher((CharSequence)entry.getKey()).find()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((InventoryTaskProgress)entry.getValue()).getPosition()));
    }

    public String toString() {
        return YamlEngine.marshal((Object)JOB_PROGRESS_YAML_SWAPPER.swapToYaml(this));
    }

    public String getDataSource() {
        return this.incrementalTaskProgressMap.keySet().stream().findAny().orElse("");
    }

    public int getInventoryFinishedPercentage() {
        long finished = this.inventoryTaskProgressMap.values().stream().filter(each -> each.getPosition() instanceof FinishedPosition).count();
        return this.inventoryTaskProgressMap.isEmpty() ? 0 : (int)(finished * 100L / (long)this.inventoryTaskProgressMap.size());
    }

    public long getIncrementalLatestActiveTimeMillis() {
        List delays = this.incrementalTaskProgressMap.values().stream().map(each -> each.getIncrementalTaskDelay().getLatestActiveTimeMillis()).collect(Collectors.toList());
        return delays.stream().reduce(Long::max).orElse(0L);
    }

    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public Map<String, InventoryTaskProgress> getInventoryTaskProgressMap() {
        return this.inventoryTaskProgressMap;
    }

    @Generated
    public Map<String, IncrementalTaskProgress> getIncrementalTaskProgressMap() {
        return this.incrementalTaskProgressMap;
    }

    @Generated
    public void setStatus(JobStatus status) {
        this.status = status;
    }

    @Generated
    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    @Generated
    public void setInventoryTaskProgressMap(Map<String, InventoryTaskProgress> inventoryTaskProgressMap) {
        this.inventoryTaskProgressMap = inventoryTaskProgressMap;
    }

    @Generated
    public void setIncrementalTaskProgressMap(Map<String, IncrementalTaskProgress> incrementalTaskProgressMap) {
        this.incrementalTaskProgressMap = incrementalTaskProgressMap;
    }
}

