/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.preparer.splitter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceManager;
import org.apache.shardingsphere.scaling.core.common.datasource.MetaDataManager;
import org.apache.shardingsphere.scaling.core.common.exception.PrepareFailedException;
import org.apache.shardingsphere.scaling.core.common.sqlbuilder.ScalingSQLBuilderFactory;
import org.apache.shardingsphere.scaling.core.config.DumperConfiguration;
import org.apache.shardingsphere.scaling.core.config.InventoryDumperConfiguration;
import org.apache.shardingsphere.scaling.core.config.TaskConfiguration;
import org.apache.shardingsphere.scaling.core.job.JobContext;
import org.apache.shardingsphere.scaling.core.job.JobStatus;
import org.apache.shardingsphere.scaling.core.job.position.PlaceholderPosition;
import org.apache.shardingsphere.scaling.core.job.position.PrimaryKeyPosition;
import org.apache.shardingsphere.scaling.core.job.position.ScalingPosition;
import org.apache.shardingsphere.scaling.core.job.progress.JobProgress;
import org.apache.shardingsphere.scaling.core.job.task.ScalingTaskFactory;
import org.apache.shardingsphere.scaling.core.job.task.inventory.InventoryTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryTaskSplitter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryTaskSplitter.class);

    public List<InventoryTask> splitInventoryData(JobContext jobContext, TaskConfiguration taskConfig, DataSourceManager dataSourceManager) {
        LinkedList<InventoryTask> result = new LinkedList<InventoryTask>();
        for (InventoryDumperConfiguration each : this.splitDumperConfig(jobContext, taskConfig.getDumperConfig(), dataSourceManager)) {
            result.add(ScalingTaskFactory.createInventoryTask(each, taskConfig.getImporterConfig()));
        }
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitDumperConfig(JobContext jobContext, DumperConfiguration dumperConfig, DataSourceManager dataSourceManager) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        DataSource dataSource = dataSourceManager.getDataSource(dumperConfig.getDataSourceConfig());
        MetaDataManager metaDataManager = new MetaDataManager(dataSource);
        for (InventoryDumperConfiguration each : this.splitByTable(dumperConfig)) {
            result.addAll(this.splitByPrimaryKey(jobContext, dataSource, metaDataManager, each));
        }
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitByTable(DumperConfiguration dumperConfig) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        dumperConfig.getTableNameMap().forEach((key, value) -> {
            InventoryDumperConfiguration inventoryDumperConfig = new InventoryDumperConfiguration(dumperConfig);
            inventoryDumperConfig.setTableName((String)key);
            inventoryDumperConfig.setPosition(new PlaceholderPosition());
            result.add(inventoryDumperConfig);
        });
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitByPrimaryKey(JobContext jobContext, DataSource dataSource, MetaDataManager metaDataManager, InventoryDumperConfiguration dumperConfig) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        Collection<ScalingPosition<?>> inventoryPositions = this.getInventoryPositions(jobContext, dumperConfig, dataSource, metaDataManager);
        int i = 0;
        for (ScalingPosition<?> inventoryPosition : inventoryPositions) {
            InventoryDumperConfiguration splitDumperConfig = new InventoryDumperConfiguration(dumperConfig);
            splitDumperConfig.setPosition(inventoryPosition);
            splitDumperConfig.setShardingItem(i++);
            splitDumperConfig.setTableName(dumperConfig.getTableName());
            splitDumperConfig.setPrimaryKey(dumperConfig.getPrimaryKey());
            result.add(splitDumperConfig);
        }
        return result;
    }

    private Collection<ScalingPosition<?>> getInventoryPositions(JobContext jobContext, InventoryDumperConfiguration dumperConfig, DataSource dataSource, MetaDataManager metaDataManager) {
        DatabaseType databaseType = dumperConfig.getDataSourceConfig().getDatabaseType();
        JobProgress initProgress = jobContext.getInitProgress();
        if (null != initProgress && initProgress.getStatus() != JobStatus.PREPARING_FAILURE) {
            Collection<ScalingPosition<?>> result = jobContext.getInitProgress().getInventoryPosition(dumperConfig.getTableName()).values();
            result.stream().findFirst().ifPresent(position -> {
                if (position instanceof PrimaryKeyPosition) {
                    String primaryKey = (String)metaDataManager.getTableMetaData(dumperConfig.getTableName(), databaseType).getPrimaryKeyColumns().get(0);
                    dumperConfig.setPrimaryKey(primaryKey);
                }
            });
            return result;
        }
        TableMetaData tableMetaData = metaDataManager.getTableMetaData(dumperConfig.getTableName(), databaseType);
        if (this.isSpiltByPrimaryKeyRange(tableMetaData, dumperConfig.getTableName())) {
            String primaryKey = (String)tableMetaData.getPrimaryKeyColumns().get(0);
            dumperConfig.setPrimaryKey(primaryKey);
            return this.getPositionByPrimaryKeyRange(jobContext, dataSource, dumperConfig);
        }
        return Collections.singletonList(new PlaceholderPosition());
    }

    private boolean isSpiltByPrimaryKeyRange(TableMetaData tableMetaData, String tableName) {
        if (null == tableMetaData) {
            log.warn("Can't split range for table {}, reason: can not get table metadata ", (Object)tableName);
            return false;
        }
        List primaryKeys = tableMetaData.getPrimaryKeyColumns();
        if (null == primaryKeys || primaryKeys.isEmpty()) {
            log.warn("Can't split range for table {}, reason: no primary key", (Object)tableName);
            return false;
        }
        if (primaryKeys.size() > 1) {
            log.warn("Can't split range for table {}, reason: primary key is union primary", (Object)tableName);
            return false;
        }
        int index = tableMetaData.findColumnIndex((String)primaryKeys.get(0));
        if (this.isNotIntegerPrimary(tableMetaData.getColumnMetaData(index).getDataType())) {
            log.warn("Can't split range for table {}, reason: primary key is not integer number", (Object)tableName);
            return false;
        }
        return true;
    }

    private boolean isNotIntegerPrimary(int columnType) {
        return 4 != columnType && -5 != columnType && 5 != columnType && -6 != columnType;
    }

    private Collection<ScalingPosition<?>> getPositionByPrimaryKeyRange(JobContext jobContext, DataSource dataSource, InventoryDumperConfiguration dumperConfig) {
        ArrayList result = new ArrayList();
        String sql = ScalingSQLBuilderFactory.newInstance(jobContext.getJobConfig().getHandleConfig().getDatabaseType()).buildSplitByPrimaryKeyRangeSQL(dumperConfig.getTableName(), dumperConfig.getPrimaryKey());
        try (Connection connection = dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(sql);){
            long beginId = 0L;
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                ps.setLong(1, beginId);
                ps.setLong(2, jobContext.getJobConfig().getHandleConfig().getShardingSize());
                try (ResultSet rs = ps.executeQuery();){
                    rs.next();
                    long endId = rs.getLong(1);
                    if (endId == 0L) break;
                    result.add(new PrimaryKeyPosition(beginId, endId));
                    beginId = endId + 1L;
                    continue;
                }
            }
            if (0 == result.size()) {
                result.add(new PrimaryKeyPosition(0L, 0L));
            }
        }
        catch (SQLException ex) {
            throw new PrepareFailedException(String.format("Split task for table %s by primary key %s error", dumperConfig.getTableName(), dumperConfig.getPrimaryKey()), ex);
        }
        return result;
    }
}

