/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.preparer;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceManager;
import org.apache.shardingsphere.scaling.core.common.exception.PrepareFailedException;
import org.apache.shardingsphere.scaling.core.config.JobConfiguration;
import org.apache.shardingsphere.scaling.core.config.TaskConfiguration;
import org.apache.shardingsphere.scaling.core.job.JobContext;
import org.apache.shardingsphere.scaling.core.job.JobStatus;
import org.apache.shardingsphere.scaling.core.job.check.EnvironmentCheckerFactory;
import org.apache.shardingsphere.scaling.core.job.check.source.DataSourceChecker;
import org.apache.shardingsphere.scaling.core.job.position.PositionInitializer;
import org.apache.shardingsphere.scaling.core.job.position.PositionInitializerFactory;
import org.apache.shardingsphere.scaling.core.job.position.ScalingPosition;
import org.apache.shardingsphere.scaling.core.job.preparer.DataSourcePreparer;
import org.apache.shardingsphere.scaling.core.job.preparer.splitter.InventoryTaskSplitter;
import org.apache.shardingsphere.scaling.core.job.progress.JobProgress;
import org.apache.shardingsphere.scaling.core.job.task.ScalingTaskFactory;
import org.apache.shardingsphere.scaling.core.job.task.inventory.InventoryTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScalingJobPreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScalingJobPreparer.class);
    private final InventoryTaskSplitter inventoryTaskSplitter = new InventoryTaskSplitter();

    public void prepare(JobContext jobContext) {
        this.prepareTarget(jobContext.getJobConfig());
        try (DataSourceManager dataSourceManager = new DataSourceManager(jobContext.getTaskConfigs());){
            this.checkDataSource(jobContext, dataSourceManager);
            this.initIncrementalTasks(jobContext, dataSourceManager);
            this.initInventoryTasks(jobContext, dataSourceManager);
        }
        catch (SQLException ex) {
            log.error("Scaling job preparing failed, jobId={}", (Object)jobContext.getJobId());
            throw new PrepareFailedException("Scaling job preparing failed, jobId=" + jobContext.getJobId(), ex);
        }
    }

    private void prepareTarget(JobConfiguration jobConfig) {
        DataSourcePreparer dataSourcePreparer = EnvironmentCheckerFactory.getDataSourcePreparer(jobConfig.getHandleConfig().getDatabaseType());
        if (null == dataSourcePreparer) {
            log.info("dataSourcePreparer null, ignore prepare target");
            return;
        }
        dataSourcePreparer.prepareTargetTables(jobConfig);
    }

    private void checkDataSource(JobContext jobContext, DataSourceManager dataSourceManager) {
        this.checkSourceDataSources(jobContext, dataSourceManager);
        JobProgress initProgress = jobContext.getInitProgress();
        if (null == initProgress || initProgress.getStatus() == JobStatus.PREPARING_FAILURE) {
            this.checkTargetDataSources(jobContext, dataSourceManager);
        }
    }

    private void checkSourceDataSources(JobContext jobContext, DataSourceManager dataSourceManager) {
        DataSourceChecker dataSourceChecker = EnvironmentCheckerFactory.newInstance(jobContext.getJobConfig().getHandleConfig().getDatabaseType());
        dataSourceChecker.checkConnection(dataSourceManager.getCachedDataSources().values());
        dataSourceChecker.checkPrivilege(dataSourceManager.getSourceDataSources().values());
        dataSourceChecker.checkVariable(dataSourceManager.getSourceDataSources().values());
    }

    private void checkTargetDataSources(JobContext jobContext, DataSourceManager dataSourceManager) {
        DataSourceChecker dataSourceChecker = EnvironmentCheckerFactory.newInstance(jobContext.getJobConfig().getHandleConfig().getDatabaseType());
        dataSourceChecker.checkTargetTable(dataSourceManager.getTargetDataSources().values(), jobContext.getTaskConfigs().iterator().next().getImporterConfig().getShardingColumnsMap().keySet());
    }

    private void initInventoryTasks(JobContext jobContext, DataSourceManager dataSourceManager) {
        LinkedList<InventoryTask> allInventoryTasks = new LinkedList<InventoryTask>();
        for (TaskConfiguration each : jobContext.getTaskConfigs()) {
            allInventoryTasks.addAll(this.inventoryTaskSplitter.splitInventoryData(jobContext, each, dataSourceManager));
        }
        jobContext.getInventoryTasks().addAll(allInventoryTasks);
    }

    private void initIncrementalTasks(JobContext jobContext, DataSourceManager dataSourceManager) throws SQLException {
        for (TaskConfiguration each : jobContext.getTaskConfigs()) {
            each.getDumperConfig().setPosition(this.getIncrementalPosition(jobContext, each, dataSourceManager));
            jobContext.getIncrementalTasks().add(ScalingTaskFactory.createIncrementalTask(each.getHandleConfig().getConcurrency(), each.getDumperConfig(), each.getImporterConfig()));
        }
    }

    private ScalingPosition<?> getIncrementalPosition(JobContext jobContext, TaskConfiguration taskConfig, DataSourceManager dataSourceManager) throws SQLException {
        Optional<ScalingPosition<?>> positionOptional;
        if (null != jobContext.getInitProgress() && (positionOptional = jobContext.getInitProgress().getIncrementalPosition(taskConfig.getDumperConfig().getDataSourceName())).isPresent()) {
            return positionOptional.get();
        }
        return PositionInitializerFactory.newInstance(taskConfig.getHandleConfig().getDatabaseType()).init(dataSourceManager.getDataSource(taskConfig.getDumperConfig().getDataSourceConfig()));
    }

    public void cleanup(JobContext jobContext) {
        try (DataSourceManager dataSourceManager = new DataSourceManager(jobContext.getTaskConfigs());){
            for (TaskConfiguration each : jobContext.getTaskConfigs()) {
                PositionInitializer positionInitializer = PositionInitializerFactory.newInstance(each.getHandleConfig().getDatabaseType());
                positionInitializer.destroy(dataSourceManager.getDataSource(each.getDumperConfig().getDataSourceConfig()));
            }
        }
        catch (SQLException ex) {
            log.warn("Scaling job destroying failed", (Throwable)ex);
        }
    }
}

