/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.preparer;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConverter;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceFactory;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceWrapper;
import org.apache.shardingsphere.scaling.core.config.JobConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.ScalingDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.ShardingSphereJDBCDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.config.yaml.ShardingRuleConfigurationSwapper;
import org.apache.shardingsphere.scaling.core.job.preparer.ActualTableDefinition;
import org.apache.shardingsphere.scaling.core.job.preparer.DataSourcePreparer;
import org.apache.shardingsphere.scaling.core.job.preparer.TableDefinitionSQLType;
import org.apache.shardingsphere.scaling.core.util.JobConfigurationUtil;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourcePreparer
implements DataSourcePreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSourcePreparer.class);
    private static final Pattern PATTERN_CREATE_TABLE_IF_NOT_EXISTS = Pattern.compile("CREATE\\s+TABLE\\s+IF\\s+NOT\\s+EXISTS\\s+", 2);
    private static final Pattern PATTERN_CREATE_TABLE = Pattern.compile("CREATE\\s+TABLE\\s+", 2);
    private static final Pattern PATTERN_ALTER_TABLE = Pattern.compile("ALTER\\s+TABLE\\s+", 2);
    private static final String[] IGNORE_EXCEPTION_MESSAGE = new String[]{"multiple primary keys for table", "already exists"};
    private final DataSourceFactory dataSourceFactory = new DataSourceFactory();

    protected DataSourceWrapper getSourceDataSource(JobConfiguration jobConfig) {
        return this.dataSourceFactory.newInstance(jobConfig.getRuleConfig().getSource().unwrap());
    }

    protected DataSourceWrapper getTargetDataSource(JobConfiguration jobConfig) {
        return this.dataSourceFactory.newInstance(jobConfig.getRuleConfig().getTarget().unwrap());
    }

    protected Collection<String> getLogicTableNames(ScalingDataSourceConfiguration sourceConfig) {
        ShardingSphereJDBCDataSourceConfiguration source = (ShardingSphereJDBCDataSourceConfiguration)sourceConfig;
        ShardingRuleConfiguration ruleConfig = ShardingRuleConfigurationSwapper.findAndConvertShardingRuleConfiguration(source.getRootConfig().getRules());
        return this.getLogicTableNames(ruleConfig);
    }

    private Collection<String> getLogicTableNames(ShardingRuleConfiguration ruleConfig) {
        ArrayList<String> result = new ArrayList<String>();
        List tableNames = ruleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toList());
        List autoTableNames = ruleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toList());
        result.addAll(tableNames);
        result.addAll(autoTableNames);
        return result;
    }

    protected Map<DataSource, Map<String, String>> getDataSourceTableNamesMap(ScalingDataSourceConfiguration sourceConfig) {
        ShardingSphereJDBCDataSourceConfiguration source = (ShardingSphereJDBCDataSourceConfiguration)sourceConfig;
        ShardingRuleConfiguration ruleConfig = ShardingRuleConfigurationSwapper.findAndConvertShardingRuleConfiguration(source.getRootConfig().getRules());
        Map<String, DataSourceConfiguration> dataSourceConfigs = JobConfigurationUtil.getDataSourceConfigurations(source.getRootConfig());
        ShardingRule shardingRule = new ShardingRule(ruleConfig, source.getRootConfig().getDataSources().keySet());
        Collection<String> logicTableNames = this.getLogicTableNames(ruleConfig);
        HashMap<String, Map> dataSourceNameTableNamesMap = new HashMap<String, Map>();
        for (String each : logicTableNames) {
            DataNode dataNode = shardingRule.getDataNode(each);
            dataSourceNameTableNamesMap.computeIfAbsent(dataNode.getDataSourceName(), key -> new LinkedHashMap()).put(dataNode.getTableName(), each);
        }
        return dataSourceNameTableNamesMap.entrySet().stream().collect(Collectors.toMap(entry -> DataSourceConverter.getDataSource((DataSourceConfiguration)((DataSourceConfiguration)dataSourceConfigs.get(entry.getKey()))), Map.Entry::getValue, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    protected void executeTargetTableSQL(Connection targetConnection, String sql) throws SQLException {
        log.info("execute target table sql: {}", (Object)sql);
        try (Statement statement = targetConnection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException ex) {
            for (String ignoreMessage : IGNORE_EXCEPTION_MESSAGE) {
                if (!ex.getMessage().contains(ignoreMessage)) continue;
                return;
            }
            throw ex;
        }
    }

    protected Collection<String> splitTableDefinitionToSQLs(ActualTableDefinition actualTableDefinition) {
        return Arrays.stream(actualTableDefinition.getTableDefinition().split(";")).collect(Collectors.toList());
    }

    protected TableDefinitionSQLType getTableDefinitionSQLType(String sql) {
        if (PATTERN_CREATE_TABLE.matcher(sql).find()) {
            return TableDefinitionSQLType.CREATE_TABLE;
        }
        if (PATTERN_ALTER_TABLE.matcher(sql).find()) {
            return TableDefinitionSQLType.ALTER_TABLE;
        }
        return TableDefinitionSQLType.UNKNOWN;
    }

    protected String addIfNotExistsForCreateTableSQL(String createTableSQL) {
        if (PATTERN_CREATE_TABLE_IF_NOT_EXISTS.matcher(createTableSQL).find()) {
            return createTableSQL;
        }
        return PATTERN_CREATE_TABLE.matcher(createTableSQL).replaceFirst("CREATE TABLE IF NOT EXISTS ");
    }

    protected String replaceActualTableNameToLogicTableName(String createOrAlterTableSQL, String actualTableName, String logicTableName) {
        int start = createOrAlterTableSQL.indexOf(actualTableName);
        if (start <= 0) {
            return createOrAlterTableSQL;
        }
        int end = start + actualTableName.length();
        return new StringBuilder(createOrAlterTableSQL).replace(start, end, logicTableName).toString();
    }
}

