/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.check.source;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.shardingsphere.scaling.core.common.exception.PrepareFailedException;
import org.apache.shardingsphere.scaling.core.common.sqlbuilder.ScalingSQLBuilder;
import org.apache.shardingsphere.scaling.core.job.check.source.DataSourceChecker;

public abstract class AbstractDataSourceChecker
implements DataSourceChecker {
    @Override
    public final void checkConnection(Collection<? extends DataSource> dataSources) {
        try {
            for (DataSource dataSource : dataSources) {
                dataSource.getConnection().close();
            }
        }
        catch (SQLException ex) {
            throw new PrepareFailedException("Data sources can not connect.", ex);
        }
    }

    @Override
    public final void checkTargetTable(Collection<? extends DataSource> dataSources, Collection<String> tableNames) {
        try {
            for (DataSource dataSource : dataSources) {
                this.checkEmpty(dataSource, tableNames);
            }
        }
        catch (SQLException ex) {
            throw new PrepareFailedException("Check target table failed.", ex);
        }
    }

    private void checkEmpty(DataSource dataSource, Collection<String> tableNames) throws SQLException {
        for (String each : tableNames) {
            PreparedStatement preparedStatement = dataSource.getConnection().prepareStatement(this.getSQLBuilder().buildCheckEmptySQL(each));
            Throwable throwable = null;
            try {
                ResultSet resultSet = preparedStatement.executeQuery();
                Throwable throwable2 = null;
                try {
                    if (!resultSet.next()) continue;
                    throw new PrepareFailedException(String.format("Target table `%s` is not empty.", each));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (resultSet == null) continue;
                    if (throwable2 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    resultSet.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (preparedStatement == null) continue;
                if (throwable != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                preparedStatement.close();
            }
        }
    }

    protected abstract ScalingSQLBuilder getSQLBuilder();
}

