/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.check.consistency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;
import org.apache.shardingsphere.scaling.core.api.DataCalculateParameter;
import org.apache.shardingsphere.scaling.core.api.ScalingDataConsistencyCheckAlgorithm;
import org.apache.shardingsphere.scaling.core.api.SingleTableDataCalculator;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceFactory;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceWrapper;
import org.apache.shardingsphere.scaling.core.common.exception.DataCheckFailException;
import org.apache.shardingsphere.scaling.core.config.datasource.ScalingDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.job.JobContext;
import org.apache.shardingsphere.scaling.core.job.check.consistency.DataConsistencyCheckResult;
import org.apache.shardingsphere.scaling.core.job.check.consistency.DataConsistencyChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataConsistencyCheckerImpl
implements DataConsistencyChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataConsistencyCheckerImpl.class);
    private final DataSourceFactory dataSourceFactory = new DataSourceFactory();
    private final JobContext jobContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DataConsistencyCheckResult> countCheck() {
        ThreadFactory threadFactory = ExecutorThreadFactoryBuilder.build((String)("job" + this.jobContext.getJobId() % 10000L + "-countCheck-%d"));
        ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2), threadFactory);
        try {
            Map map = this.jobContext.getTaskConfigs().stream().flatMap(each -> each.getDumperConfig().getTableNameMap().values().stream()).collect(Collectors.toSet()).stream().collect(Collectors.toMap(Function.identity(), table -> this.countCheck((String)table, executor), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
            return map;
        }
        finally {
            executor.shutdown();
            executor.shutdownNow();
        }
    }

    /*
     * Exception decompiling
     */
    private DataConsistencyCheckResult countCheck(String table, ThreadPoolExecutor executor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private long count(DataSource dataSource, String table, DatabaseType databaseType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Map<String, Boolean> dataCheck(ScalingDataConsistencyCheckAlgorithm checkAlgorithm) {
        Collection<String> supportedDatabaseTypes = checkAlgorithm.getSupportedDatabaseTypes();
        ScalingDataSourceConfiguration sourceConfig = this.jobContext.getJobConfig().getRuleConfig().getSource().unwrap();
        this.checkDatabaseTypeSupportedOrNot(supportedDatabaseTypes, sourceConfig.getDatabaseType().getName());
        ScalingDataSourceConfiguration targetConfig = this.jobContext.getJobConfig().getRuleConfig().getTarget().unwrap();
        this.checkDatabaseTypeSupportedOrNot(supportedDatabaseTypes, targetConfig.getDatabaseType().getName());
        Collection logicTableNames = this.jobContext.getTaskConfigs().stream().flatMap(each -> each.getDumperConfig().getTableNameMap().values().stream()).distinct().collect(Collectors.toList());
        Map<String, Collection<String>> tablesColumnNamesMap = this.getTablesColumnNamesMap(sourceConfig);
        logicTableNames.forEach(each -> {
            if (!tablesColumnNamesMap.containsKey(each)) {
                throw new DataCheckFailException(String.format("could not get table columns for '%s'", each));
            }
        });
        SingleTableDataCalculator sourceCalculator = checkAlgorithm.getSingleTableDataCalculator(sourceConfig.getDatabaseType().getName());
        SingleTableDataCalculator targetCalculator = checkAlgorithm.getSingleTableDataCalculator(targetConfig.getDatabaseType().getName());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        ThreadFactory threadFactory = ExecutorThreadFactoryBuilder.build((String)("job" + this.jobContext.getJobId() % 10000L + "-dataCheck-%d"));
        ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2), threadFactory);
        try {
            for (String each2 : logicTableNames) {
                Collection<String> columnNames = tablesColumnNamesMap.get(each2);
                DataCalculateParameter sourceCalculateParameter = DataCalculateParameter.builder().dataSourceConfig(sourceConfig).logicTableName(each2).columnNames(columnNames).build();
                Future<Object> sourceFuture = executor.submit(() -> sourceCalculator.dataCalculate(sourceCalculateParameter));
                DataCalculateParameter targetCalculateParameter = DataCalculateParameter.builder().dataSourceConfig(targetConfig).logicTableName(each2).columnNames(columnNames).build();
                Future<Object> targetFuture = executor.submit(() -> targetCalculator.dataCalculate(targetCalculateParameter));
                Object sourceCalculateResult = sourceFuture.get();
                Object targetCalculateResult = targetFuture.get();
                boolean calculateResultsEquals = Objects.equals(sourceCalculateResult, targetCalculateResult);
                result.put(each2, calculateResultsEquals);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new DataCheckFailException("data check failed");
        }
        finally {
            executor.shutdown();
            executor.shutdownNow();
        }
        return result;
    }

    private void checkDatabaseTypeSupportedOrNot(Collection<String> supportedDatabaseTypes, String databaseType) {
        if (!supportedDatabaseTypes.contains(databaseType)) {
            throw new DataCheckFailException("database type " + databaseType + " is not supported in " + supportedDatabaseTypes);
        }
    }

    /*
     * Exception decompiling
     */
    private Map<String, Collection<String>> getTablesColumnNamesMap(ScalingDataSourceConfiguration dataSourceConfig) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Generated
    public DataConsistencyCheckerImpl(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    @Generated
    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    @Generated
    public JobContext getJobContext() {
        return this.jobContext;
    }

    private static /* synthetic */ Collection lambda$getTablesColumnNamesMap$9(String tableName) {
        return new ArrayList();
    }

    private /* synthetic */ Long lambda$countCheck$4(DataSourceWrapper targetDataSource, String table, ScalingDataSourceConfiguration targetConfig) throws Exception {
        return this.count(targetDataSource, table, targetConfig.getDatabaseType());
    }

    private /* synthetic */ Long lambda$countCheck$3(DataSourceWrapper sourceDataSource, String table, ScalingDataSourceConfiguration sourceConfig) throws Exception {
        return this.count(sourceDataSource, table, sourceConfig.getDatabaseType());
    }
}

