/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.check;

import org.apache.shardingsphere.scaling.core.job.JobContext;
import org.apache.shardingsphere.scaling.core.job.check.consistency.DataConsistencyChecker;
import org.apache.shardingsphere.scaling.core.job.check.consistency.DataConsistencyCheckerImpl;
import org.apache.shardingsphere.scaling.core.job.check.source.DataSourceChecker;
import org.apache.shardingsphere.scaling.core.job.preparer.DataSourcePreparer;
import org.apache.shardingsphere.scaling.core.spi.ScalingEntry;
import org.apache.shardingsphere.scaling.core.spi.ScalingEntryLoader;

public final class EnvironmentCheckerFactory {
    public static DataConsistencyChecker newInstance(JobContext jobContext) {
        return new DataConsistencyCheckerImpl(jobContext);
    }

    public static DataSourceChecker newInstance(String databaseType) {
        ScalingEntry scalingEntry = ScalingEntryLoader.getInstance(databaseType);
        return scalingEntry.getEnvironmentCheckerClass().getConstructor(new Class[0]).newInstance(new Object[0]).getDataSourceCheckerClass().getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static DataSourcePreparer getDataSourcePreparer(String databaseType) {
        ScalingEntry scalingEntry = ScalingEntryLoader.getInstance(databaseType);
        Class<? extends DataSourcePreparer> preparerClass = scalingEntry.getEnvironmentCheckerClass().getConstructor(new Class[0]).newInstance(new Object[0]).getDataSourcePreparerClass();
        if (null == preparerClass) {
            return null;
        }
        return preparerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

