/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job;

import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.apache.shardingsphere.elasticjob.simple.job.SimpleJob;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.scaling.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.scaling.core.api.ScalingAPIFactory;
import org.apache.shardingsphere.scaling.core.config.JobConfiguration;
import org.apache.shardingsphere.scaling.core.job.JobContext;
import org.apache.shardingsphere.scaling.core.job.JobStatus;
import org.apache.shardingsphere.scaling.core.job.preparer.ScalingJobPreparer;
import org.apache.shardingsphere.scaling.core.job.schedule.JobSchedulerCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScalingJob
implements SimpleJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScalingJob.class);
    private final GovernanceRepositoryAPI governanceRepositoryAPI = ScalingAPIFactory.getGovernanceRepositoryAPI();
    private final ScalingJobPreparer jobPreparer = new ScalingJobPreparer();

    public void execute(ShardingContext shardingContext) {
        log.info("Execute scaling job {}-{}", (Object)shardingContext.getJobName(), (Object)shardingContext.getShardingItem());
        JobConfiguration jobConfig = (JobConfiguration)YamlEngine.unmarshal((String)shardingContext.getJobParameter(), JobConfiguration.class);
        jobConfig.getHandleConfig().setShardingItem(shardingContext.getShardingItem());
        JobContext jobContext = new JobContext(jobConfig);
        jobContext.setInitProgress(this.governanceRepositoryAPI.getJobProgress(jobContext.getJobId(), jobContext.getShardingItem()));
        jobContext.setJobPreparer(this.jobPreparer);
        try {
            this.jobPreparer.prepare(jobContext);
        }
        catch (RuntimeException ex) {
            log.error("job prepare failed, {}-{}", (Object)shardingContext.getJobName(), (Object)shardingContext.getShardingItem());
            jobContext.setStatus(JobStatus.PREPARING_FAILURE);
            this.governanceRepositoryAPI.persistJobProgress(jobContext);
            throw ex;
        }
        this.governanceRepositoryAPI.persistJobProgress(jobContext);
        JobSchedulerCenter.start(jobContext);
    }
}

