/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job;

import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.config.JobConfiguration;
import org.apache.shardingsphere.scaling.core.config.TaskConfiguration;
import org.apache.shardingsphere.scaling.core.job.JobStatus;
import org.apache.shardingsphere.scaling.core.job.preparer.ScalingJobPreparer;
import org.apache.shardingsphere.scaling.core.job.progress.JobProgress;
import org.apache.shardingsphere.scaling.core.job.task.incremental.IncrementalTask;
import org.apache.shardingsphere.scaling.core.job.task.inventory.InventoryTask;
import org.apache.shardingsphere.scaling.core.util.JobConfigurationUtil;

public final class JobContext {
    private final long jobId;
    private final int shardingItem;
    private JobStatus status = JobStatus.RUNNING;
    private JobProgress initProgress;
    private final List<TaskConfiguration> taskConfigs;
    private final List<InventoryTask> inventoryTasks = new LinkedList<InventoryTask>();
    private final List<IncrementalTask> incrementalTasks = new LinkedList<IncrementalTask>();
    private final JobConfiguration jobConfig;
    private ScalingJobPreparer jobPreparer;

    public JobContext(JobConfiguration jobConfig) {
        this.jobConfig = jobConfig;
        JobConfigurationUtil.fillInProperties(jobConfig);
        this.jobId = jobConfig.getHandleConfig().getJobId();
        this.shardingItem = jobConfig.getHandleConfig().getShardingItem();
        this.taskConfigs = JobConfigurationUtil.toTaskConfigs(jobConfig);
    }

    @Generated
    public long getJobId() {
        return this.jobId;
    }

    @Generated
    public int getShardingItem() {
        return this.shardingItem;
    }

    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @Generated
    public JobProgress getInitProgress() {
        return this.initProgress;
    }

    @Generated
    public List<TaskConfiguration> getTaskConfigs() {
        return this.taskConfigs;
    }

    @Generated
    public List<InventoryTask> getInventoryTasks() {
        return this.inventoryTasks;
    }

    @Generated
    public List<IncrementalTask> getIncrementalTasks() {
        return this.incrementalTasks;
    }

    @Generated
    public JobConfiguration getJobConfig() {
        return this.jobConfig;
    }

    @Generated
    public ScalingJobPreparer getJobPreparer() {
        return this.jobPreparer;
    }

    @Generated
    public void setStatus(JobStatus status) {
        this.status = status;
    }

    @Generated
    public void setInitProgress(JobProgress initProgress) {
        this.initProgress = initProgress;
    }

    @Generated
    public void setJobPreparer(ScalingJobPreparer jobPreparer) {
        this.jobPreparer = jobPreparer;
    }
}

