/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.apache.shardingsphere.elasticjob.simple.job.SimpleJob;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.scaling.core.api.JobInfo;
import org.apache.shardingsphere.scaling.core.api.ScalingAPI;
import org.apache.shardingsphere.scaling.core.api.ScalingAPIFactory;
import org.apache.shardingsphere.scaling.core.config.JobConfiguration;
import org.apache.shardingsphere.scaling.core.job.check.consistency.DataConsistencyCheckResult;
import org.apache.shardingsphere.scaling.core.util.ScalingTaskUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FinishedCheckJob
implements SimpleJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FinishedCheckJob.class);
    private final ScalingAPI scalingAPI = ScalingAPIFactory.getScalingAPI();

    public void execute(ShardingContext shardingContext) {
        List<JobInfo> jobInfos = this.scalingAPI.list();
        for (JobInfo jobInfo : jobInfos) {
            if (!jobInfo.isActive()) continue;
            long jobId = jobInfo.getJobId();
            try {
                JobConfiguration jobConfig = (JobConfiguration)YamlEngine.unmarshal((String)jobInfo.getJobParameter(), JobConfiguration.class);
                if (!ScalingTaskUtil.almostFinished(this.scalingAPI.getProgress(jobId), jobConfig.getHandleConfig())) continue;
                log.info("scaling job {} almost finished.", (Object)jobId);
                if (!this.scalingAPI.isDataConsistencyCheckNeeded()) {
                    log.info("dataConsistencyCheckAlgorithm is not configured, data consistency check is ignored.");
                    this.scalingAPI.switchClusterConfiguration(jobId);
                    continue;
                }
                if (!this.dataConsistencyCheck(jobId)) {
                    log.error("data consistency check failed, job {}", (Object)jobId);
                    continue;
                }
                this.scalingAPI.switchClusterConfiguration(jobId);
            }
            catch (Exception ex) {
                log.error("scaling job {} finish check failed!", (Object)jobId, (Object)ex);
            }
        }
    }

    private boolean dataConsistencyCheck(long jobId) {
        Map<String, DataConsistencyCheckResult> checkResultMap = this.scalingAPI.dataConsistencyCheck(jobId);
        return this.scalingAPI.aggregateDataConsistencyCheckResults(jobId, checkResultMap);
    }
}

