/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.executor.job;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.OneOffJobBootstrap;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;
import org.apache.shardingsphere.scaling.core.api.ScalingAPIFactory;
import org.apache.shardingsphere.scaling.core.executor.AbstractScalingExecutor;
import org.apache.shardingsphere.scaling.core.job.ScalingJob;
import org.apache.shardingsphere.scaling.core.job.schedule.JobSchedulerCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScalingJobExecutor
extends AbstractScalingExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScalingJobExecutor.class);
    private static final Pattern CONFIG_PATTERN = Pattern.compile("/scaling/(\\d+)/config");
    private static final Set<String> EXECUTING_JOBS = Sets.newConcurrentHashSet();

    @Override
    public void start() {
        super.start();
        log.info("Start scaling job executor.");
        this.watchGovernanceRepositoryConfiguration();
    }

    private void watchGovernanceRepositoryConfiguration() {
        ScalingAPIFactory.getGovernanceRepositoryAPI().watch("/scaling", event -> {
            Optional<JobConfigurationPOJO> jobConfigPOJOOptional = this.getJobConfigPOJO(event);
            if (!jobConfigPOJOOptional.isPresent()) {
                return;
            }
            JobConfigurationPOJO jobConfigPOJO = jobConfigPOJOOptional.get();
            if (DataChangedEvent.Type.DELETED == event.getType() || jobConfigPOJO.isDisabled()) {
                log.info("remove and stop {}", (Object)jobConfigPOJO.getJobName());
                EXECUTING_JOBS.remove(jobConfigPOJO.getJobName());
                JobSchedulerCenter.stop(Long.parseLong(jobConfigPOJO.getJobName()));
                return;
            }
            switch (event.getType()) {
                case ADDED: 
                case UPDATED: {
                    this.execute(jobConfigPOJO);
                    break;
                }
            }
        });
    }

    private Optional<JobConfigurationPOJO> getJobConfigPOJO(DataChangedEvent event) {
        try {
            if (CONFIG_PATTERN.matcher(event.getKey()).matches()) {
                log.info("{} job config: {}", (Object)event.getType(), (Object)event.getKey());
                return Optional.of(YamlEngine.unmarshal((String)event.getValue(), JobConfigurationPOJO.class));
            }
        }
        catch (Exception ex) {
            log.error("analyze job config pojo failed.", (Throwable)ex);
        }
        return Optional.empty();
    }

    private void execute(JobConfigurationPOJO jobConfigPOJO) {
        if (EXECUTING_JOBS.add(jobConfigPOJO.getJobName())) {
            log.info("{} added to executing jobs success", (Object)jobConfigPOJO.getJobName());
            new OneOffJobBootstrap(ScalingAPIFactory.getRegistryCenter(), (ElasticJob)new ScalingJob(), jobConfigPOJO.toJobConfiguration()).execute();
        } else {
            log.info("{} added to executing jobs failed since it already exists", (Object)jobConfigPOJO.getJobName());
        }
    }
}

