/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.executor.job;

import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.ScheduleJobBootstrap;
import org.apache.shardingsphere.scaling.core.api.ScalingAPIFactory;
import org.apache.shardingsphere.scaling.core.api.ScalingClusterAutoSwitchAlgorithm;
import org.apache.shardingsphere.scaling.core.config.ScalingContext;
import org.apache.shardingsphere.scaling.core.executor.AbstractScalingExecutor;
import org.apache.shardingsphere.scaling.core.job.FinishedCheckJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FinishedCheckJobExecutor
extends AbstractScalingExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FinishedCheckJobExecutor.class);
    private static final String JOB_NAME = "_finished_check";
    private static final String CRON_EXPRESSION = "0 * * * * ?";

    @Override
    public void start() {
        super.start();
        ScalingClusterAutoSwitchAlgorithm clusterAutoSwitchAlgorithm = ScalingContext.getInstance().getClusterAutoSwitchAlgorithm();
        if (null == clusterAutoSwitchAlgorithm) {
            log.info("clusterAutoSwitchAlgorithm not configured, auto switch will not be enabled. You could query migration progress and switch manually with DistSQL.");
            return;
        }
        log.info("Start finished check job executor.");
        new ScheduleJobBootstrap(ScalingAPIFactory.getRegistryCenter(), (ElasticJob)new FinishedCheckJob(), this.createJobConfig()).schedule();
    }

    private JobConfiguration createJobConfig() {
        return JobConfiguration.newBuilder((String)JOB_NAME, (int)1).cron(CRON_EXPRESSION).build();
    }
}

