/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.executor.importer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shardingsphere.scaling.core.common.channel.Channel;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceManager;
import org.apache.shardingsphere.scaling.core.common.exception.ScalingTaskExecuteException;
import org.apache.shardingsphere.scaling.core.common.record.Column;
import org.apache.shardingsphere.scaling.core.common.record.DataRecord;
import org.apache.shardingsphere.scaling.core.common.record.FinishedRecord;
import org.apache.shardingsphere.scaling.core.common.record.GroupedDataRecord;
import org.apache.shardingsphere.scaling.core.common.record.Record;
import org.apache.shardingsphere.scaling.core.common.record.RecordUtil;
import org.apache.shardingsphere.scaling.core.common.sqlbuilder.ScalingSQLBuilder;
import org.apache.shardingsphere.scaling.core.config.ImporterConfiguration;
import org.apache.shardingsphere.scaling.core.executor.AbstractScalingExecutor;
import org.apache.shardingsphere.scaling.core.executor.importer.DataRecordMerger;
import org.apache.shardingsphere.scaling.core.executor.importer.Importer;
import org.apache.shardingsphere.scaling.core.executor.importer.ImporterListener;
import org.apache.shardingsphere.scaling.core.util.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImporter
extends AbstractScalingExecutor
implements Importer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractImporter.class);
    private static final DataRecordMerger MERGER = new DataRecordMerger();
    private final ImporterConfiguration importerConfig;
    private final DataSourceManager dataSourceManager;
    private final ScalingSQLBuilder scalingSqlBuilder;
    private Channel channel;
    private ImporterListener importerListener;

    protected AbstractImporter(ImporterConfiguration importerConfig, DataSourceManager dataSourceManager) {
        this.importerConfig = importerConfig;
        this.dataSourceManager = dataSourceManager;
        this.scalingSqlBuilder = this.createSQLBuilder(importerConfig.getShardingColumnsMap());
    }

    protected abstract ScalingSQLBuilder createSQLBuilder(Map<String, Set<String>> var1);

    @Override
    public final void start() {
        super.start();
        this.write();
    }

    @Override
    public final void write() {
        log.info("importer write");
        int rowCount = 0;
        while (this.isRunning()) {
            List<Record> records = this.channel.fetchRecords(1024, 3);
            if (null != records && !records.isEmpty()) {
                rowCount += records.size();
                this.flush(this.dataSourceManager.getDataSource(this.importerConfig.getDataSourceConfig()), records);
                if (null != this.importerListener) {
                    this.importerListener.recordsImported(records);
                }
                if (FinishedRecord.class.equals(records.get(records.size() - 1).getClass())) {
                    this.channel.ack();
                    break;
                }
            }
            this.channel.ack();
        }
        log.info("importer write, rowCount={}", (Object)rowCount);
    }

    private void flush(DataSource dataSource, List<Record> buffer) {
        List<GroupedDataRecord> groupedDataRecords = MERGER.group(buffer.stream().filter(each -> each instanceof DataRecord).map(each -> (DataRecord)each).collect(Collectors.toList()));
        groupedDataRecords.forEach(each -> {
            if (CollectionUtils.isNotEmpty(each.getDeleteDataRecords())) {
                this.flushInternal(dataSource, each.getDeleteDataRecords());
            }
            if (CollectionUtils.isNotEmpty(each.getInsertDataRecords())) {
                this.flushInternal(dataSource, each.getInsertDataRecords());
            }
            if (CollectionUtils.isNotEmpty(each.getUpdateDataRecords())) {
                this.flushInternal(dataSource, each.getUpdateDataRecords());
            }
        });
    }

    private void flushInternal(DataSource dataSource, List<DataRecord> buffer) {
        boolean success = this.tryFlush(dataSource, buffer);
        if (this.isRunning() && !success) {
            throw new ScalingTaskExecuteException("write failed.");
        }
    }

    private boolean tryFlush(DataSource dataSource, List<DataRecord> buffer) {
        for (int i = 0; this.isRunning() && i <= this.importerConfig.getRetryTimes(); ++i) {
            try {
                this.doFlush(dataSource, buffer);
                return true;
            }
            catch (SQLException ex) {
                log.error("flush failed {}/{} times.", new Object[]{i, this.importerConfig.getRetryTimes(), ex});
                ThreadUtil.sleep(Math.min(300000L, (long)(1000 << i)));
                continue;
            }
        }
        return false;
    }

    private void doFlush(DataSource dataSource, List<DataRecord> buffer) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            connection.setAutoCommit(false);
            switch (buffer.get(0).getType()) {
                case "INSERT": {
                    this.executeBatchInsert(connection, buffer);
                    break;
                }
                case "UPDATE": {
                    this.executeUpdate(connection, buffer);
                    break;
                }
                case "DELETE": {
                    this.executeBatchDelete(connection, buffer);
                    break;
                }
            }
            connection.commit();
        }
    }

    private void executeBatchInsert(Connection connection, List<DataRecord> dataRecords) throws SQLException {
        String insertSql = this.scalingSqlBuilder.buildInsertSQL(dataRecords.get(0));
        try (PreparedStatement ps = connection.prepareStatement(insertSql);){
            ps.setQueryTimeout(30);
            for (DataRecord each : dataRecords) {
                for (int i = 0; i < each.getColumnCount(); ++i) {
                    ps.setObject(i + 1, each.getColumn(i).getValue());
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    private void executeUpdate(Connection connection, List<DataRecord> dataRecords) throws SQLException {
        for (DataRecord each : dataRecords) {
            this.executeUpdate(connection, each);
        }
    }

    private void executeUpdate(Connection connection, DataRecord record) throws SQLException {
        List<Column> conditionColumns = RecordUtil.extractConditionColumns(record, this.importerConfig.getShardingColumnsMap().get(record.getTableName()));
        List<Column> updatedColumns = this.scalingSqlBuilder.extractUpdatedColumns(record.getColumns(), record);
        String updateSql = this.scalingSqlBuilder.buildUpdateSQL(record, conditionColumns);
        try (PreparedStatement ps = connection.prepareStatement(updateSql);){
            int i;
            for (i = 0; i < updatedColumns.size(); ++i) {
                ps.setObject(i + 1, updatedColumns.get(i).getValue());
            }
            for (i = 0; i < conditionColumns.size(); ++i) {
                Column keyColumn = conditionColumns.get(i);
                ps.setObject(updatedColumns.size() + i + 1, keyColumn.isPrimaryKey() && keyColumn.isUpdated() ? keyColumn.getOldValue() : keyColumn.getValue());
            }
            ps.execute();
        }
    }

    private void executeBatchDelete(Connection connection, List<DataRecord> dataRecords) throws SQLException {
        List<Column> conditionColumns = RecordUtil.extractConditionColumns(dataRecords.get(0), this.importerConfig.getShardingColumnsMap().get(dataRecords.get(0).getTableName()));
        String deleteSQL = this.scalingSqlBuilder.buildDeleteSQL(dataRecords.get(0), conditionColumns);
        try (PreparedStatement ps = connection.prepareStatement(deleteSQL);){
            ps.setQueryTimeout(30);
            for (DataRecord each : dataRecords) {
                conditionColumns = RecordUtil.extractConditionColumns(each, this.importerConfig.getShardingColumnsMap().get(each.getTableName()));
                for (int i = 0; i < conditionColumns.size(); ++i) {
                    ps.setObject(i + 1, conditionColumns.get(i).getValue());
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    @Override
    @Generated
    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    @Override
    @Generated
    public void setImporterListener(ImporterListener importerListener) {
        this.importerListener = importerListener;
    }
}

