/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.executor.dumper;

import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceManager;
import org.apache.shardingsphere.scaling.core.config.DumperConfiguration;
import org.apache.shardingsphere.scaling.core.config.InventoryDumperConfiguration;
import org.apache.shardingsphere.scaling.core.executor.dumper.IncrementalDumper;
import org.apache.shardingsphere.scaling.core.executor.dumper.InventoryDumper;
import org.apache.shardingsphere.scaling.core.job.position.ScalingPosition;
import org.apache.shardingsphere.scaling.core.spi.ScalingEntry;
import org.apache.shardingsphere.scaling.core.spi.ScalingEntryLoader;

public final class DumperFactory {
    public static InventoryDumper newInstanceJdbcDumper(InventoryDumperConfiguration inventoryDumperConfig, DataSourceManager dataSourceManager) {
        ScalingEntry scalingEntry = ScalingEntryLoader.getInstance(inventoryDumperConfig.getDataSourceConfig().getDatabaseType().getName());
        return scalingEntry.getInventoryDumperClass().getConstructor(InventoryDumperConfiguration.class, DataSourceManager.class).newInstance(inventoryDumperConfig, dataSourceManager);
    }

    public static IncrementalDumper newInstanceLogDumper(DumperConfiguration dumperConfig, ScalingPosition<?> position) {
        return DumperFactory.newInstanceLogDumper(dumperConfig.getDataSourceConfig().getDatabaseType().getName(), dumperConfig, position);
    }

    public static IncrementalDumper newInstanceLogDumper(String databaseType, DumperConfiguration dumperConfig, ScalingPosition<?> position) {
        ScalingEntry scalingEntry = ScalingEntryLoader.getInstance(databaseType);
        return scalingEntry.getIncrementalDumperClass().getConstructor(DumperConfiguration.class, ScalingPosition.class).newInstance(dumperConfig, position);
    }

    @Generated
    private DumperFactory() {
    }
}

