/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.executor.dumper;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.scaling.core.common.channel.Channel;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceManager;
import org.apache.shardingsphere.scaling.core.common.datasource.MetaDataManager;
import org.apache.shardingsphere.scaling.core.common.exception.ScalingTaskExecuteException;
import org.apache.shardingsphere.scaling.core.common.record.Column;
import org.apache.shardingsphere.scaling.core.common.record.DataRecord;
import org.apache.shardingsphere.scaling.core.common.record.FinishedRecord;
import org.apache.shardingsphere.scaling.core.common.record.Record;
import org.apache.shardingsphere.scaling.core.config.InventoryDumperConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.ScalingDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.StandardJDBCDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.executor.AbstractScalingExecutor;
import org.apache.shardingsphere.scaling.core.executor.dumper.InventoryDumper;
import org.apache.shardingsphere.scaling.core.job.position.FinishedPosition;
import org.apache.shardingsphere.scaling.core.job.position.PlaceholderPosition;
import org.apache.shardingsphere.scaling.core.job.position.PrimaryKeyPosition;
import org.apache.shardingsphere.scaling.core.job.position.ScalingPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInventoryDumper
extends AbstractScalingExecutor
implements InventoryDumper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractInventoryDumper.class);
    private final InventoryDumperConfiguration inventoryDumperConfig;
    private final DataSourceManager dataSourceManager;
    private final TableMetaData tableMetaData;
    private Channel channel;

    protected AbstractInventoryDumper(InventoryDumperConfiguration inventoryDumperConfig, DataSourceManager dataSourceManager) {
        if (!StandardJDBCDataSourceConfiguration.class.equals(inventoryDumperConfig.getDataSourceConfig().getClass())) {
            throw new UnsupportedOperationException("AbstractInventoryDumper only support StandardJDBCDataSourceConfiguration");
        }
        this.inventoryDumperConfig = inventoryDumperConfig;
        this.dataSourceManager = dataSourceManager;
        this.tableMetaData = this.createTableMetaData();
    }

    private TableMetaData createTableMetaData() {
        ScalingDataSourceConfiguration dataSourceConfig = this.inventoryDumperConfig.getDataSourceConfig();
        MetaDataManager metaDataManager = new MetaDataManager(this.dataSourceManager.getDataSource(dataSourceConfig));
        return metaDataManager.getTableMetaData(this.inventoryDumperConfig.getTableName(), dataSourceConfig.getDatabaseType());
    }

    @Override
    public final void start() {
        super.start();
        this.dump();
    }

    private void dump() {
        try (Connection conn = this.dataSourceManager.getDataSource(this.inventoryDumperConfig.getDataSourceConfig()).getConnection();){
            String sql = String.format("SELECT * FROM %s %s", this.inventoryDumperConfig.getTableName(), this.getWhereCondition(this.inventoryDumperConfig.getPrimaryKey(), this.inventoryDumperConfig.getPosition()));
            log.info("inventory dump, sql={}", (Object)sql);
            PreparedStatement ps = this.createPreparedStatement(conn, sql);
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = 0;
            while (this.isRunning() && rs.next()) {
                DataRecord record = new DataRecord(this.newPosition(rs), metaData.getColumnCount());
                record.setType("INSERT");
                record.setTableName(this.inventoryDumperConfig.getTableNameMap().get(this.inventoryDumperConfig.getTableName()));
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    record.addColumn(new Column(metaData.getColumnName(i), this.readValue(rs, i), true, this.tableMetaData.isPrimaryKey(i - 1)));
                }
                this.pushRecord(record);
                ++rowCount;
            }
            log.info("dump, rowCount={}", (Object)rowCount);
            this.pushRecord(new FinishedRecord(new FinishedPosition()));
        }
        catch (SQLException ex) {
            this.stop();
            this.channel.close();
            throw new ScalingTaskExecuteException(ex);
        }
        finally {
            this.pushRecord(new FinishedRecord(new PlaceholderPosition()));
        }
    }

    private String getWhereCondition(String primaryKey, ScalingPosition<?> position) {
        if (null == primaryKey || null == position) {
            return "";
        }
        PrimaryKeyPosition primaryKeyPosition = (PrimaryKeyPosition)position;
        return String.format("WHERE %s BETWEEN %d AND %d", primaryKey, primaryKeyPosition.getBeginValue(), primaryKeyPosition.getEndValue());
    }

    private ScalingPosition<?> newPosition(ResultSet rs) throws SQLException {
        if (null == this.inventoryDumperConfig.getPrimaryKey()) {
            return new PlaceholderPosition();
        }
        return new PrimaryKeyPosition(rs.getLong(this.inventoryDumperConfig.getPrimaryKey()), ((PrimaryKeyPosition)this.inventoryDumperConfig.getPosition()).getEndValue());
    }

    protected abstract PreparedStatement createPreparedStatement(Connection var1, String var2) throws SQLException;

    protected Object readValue(ResultSet resultSet, int index) throws SQLException {
        return resultSet.getObject(index);
    }

    private void pushRecord(Record record) {
        try {
            this.channel.pushRecord(record);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Generated
    protected InventoryDumperConfiguration getInventoryDumperConfig() {
        return this.inventoryDumperConfig;
    }

    @Override
    @Generated
    public void setChannel(Channel channel) {
        this.channel = channel;
    }
}

