/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.config.datasource;

import com.zaxxer.hikari.HikariConfig;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConverter;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.scaling.core.config.datasource.ScalingDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.ScalingDataSourceConfigurationWrap;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public final class StandardJDBCDataSourceConfiguration
implements ScalingDataSourceConfiguration {
    public static final String TYPE = "JDBC";
    private static final String DATA_SOURCE_CLASS_NAME = "dataSourceClassName";
    private final String parameter;
    private final DataSourceConfiguration dataSourceConfig;
    private final HikariConfig hikariConfig;
    private final DatabaseType databaseType;

    public StandardJDBCDataSourceConfiguration(String parameter) {
        this.parameter = parameter;
        Map yamlConfig = (Map)YamlEngine.unmarshal((String)parameter, Map.class);
        if (!yamlConfig.containsKey(DATA_SOURCE_CLASS_NAME)) {
            yamlConfig.put(DATA_SOURCE_CLASS_NAME, "com.zaxxer.hikari.HikariDataSource");
        }
        this.dataSourceConfig = new YamlDataSourceConfigurationSwapper().swapToDataSourceConfiguration(yamlConfig);
        yamlConfig.remove(DATA_SOURCE_CLASS_NAME);
        this.hikariConfig = this.unmarshalSkipMissingProperties(YamlEngine.marshal((Object)yamlConfig), HikariConfig.class);
        this.databaseType = DatabaseTypeRegistry.getDatabaseTypeByURL((String)this.hikariConfig.getJdbcUrl());
    }

    public StandardJDBCDataSourceConfiguration(String jdbcUrl, String username, String password) {
        this(StandardJDBCDataSourceConfiguration.wrapParameter(jdbcUrl, username, password));
    }

    private <T> T unmarshalSkipMissingProperties(String yamlContent, Class<T> classType) {
        Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(true);
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(classType), representer);
        return (T)yaml.loadAs(yamlContent, classType);
    }

    private static String wrapParameter(String jdbcUrl, String username, String password) {
        HashMap<String, String> parameter = new HashMap<String, String>(3, 1.0f);
        parameter.put("jdbcUrl", jdbcUrl);
        parameter.put("username", username);
        parameter.put("password", password);
        return YamlEngine.marshal(parameter);
    }

    @Override
    public ScalingDataSourceConfigurationWrap wrap() {
        ScalingDataSourceConfigurationWrap result = new ScalingDataSourceConfigurationWrap();
        result.setType(TYPE);
        result.setParameter(this.parameter);
        return result;
    }

    @Override
    public DataSource toDataSource() {
        return DataSourceConverter.getDataSource((DataSourceConfiguration)this.dataSourceConfig);
    }

    @Generated
    public String getParameter() {
        return this.parameter;
    }

    @Generated
    public DataSourceConfiguration getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    @Generated
    public HikariConfig getHikariConfig() {
        return this.hikariConfig;
    }

    @Override
    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardJDBCDataSourceConfiguration)) {
            return false;
        }
        StandardJDBCDataSourceConfiguration other = (StandardJDBCDataSourceConfiguration)o;
        String this$parameter = this.getParameter();
        String other$parameter = other.getParameter();
        return !(this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
        return result;
    }
}

