/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.config.datasource;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.driver.api.ShardingSphereDataSourceFactory;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.scaling.core.config.datasource.ScalingDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.ScalingDataSourceConfigurationWrap;
import org.apache.shardingsphere.scaling.core.config.yaml.ShardingRuleConfigurationSwapper;
import org.apache.shardingsphere.scaling.core.config.yaml.YamlParameterConfiguration;
import org.apache.shardingsphere.scaling.core.util.JDBCUtil;

public final class ShardingSphereJDBCDataSourceConfiguration
implements ScalingDataSourceConfiguration {
    public static final String TYPE = "ShardingSphereJDBC";
    private final String parameter;
    private final YamlRootConfiguration rootConfig;
    private final DatabaseType databaseType;

    public ShardingSphereJDBCDataSourceConfiguration(String parameter) {
        this.parameter = parameter;
        this.rootConfig = (YamlRootConfiguration)YamlEngine.unmarshal((String)parameter, YamlRootConfiguration.class);
        Map props = (Map)this.rootConfig.getDataSources().values().iterator().next();
        this.databaseType = DatabaseTypeRegistry.getDatabaseTypeByURL((String)JDBCUtil.getJdbcUrl(props));
    }

    public ShardingSphereJDBCDataSourceConfiguration(YamlRootConfiguration rootConfig) {
        YamlParameterConfiguration parameterConfig = new YamlParameterConfiguration(rootConfig.getDataSources(), rootConfig.getRules());
        this.parameter = YamlEngine.marshal((Object)parameterConfig);
        this.rootConfig = rootConfig;
        Map props = (Map)rootConfig.getDataSources().values().iterator().next();
        this.databaseType = DatabaseTypeRegistry.getDatabaseTypeByURL((String)JDBCUtil.getJdbcUrl(props));
    }

    @Override
    public ScalingDataSourceConfigurationWrap wrap() {
        ScalingDataSourceConfigurationWrap result = new ScalingDataSourceConfigurationWrap();
        result.setSchemaName(this.rootConfig.getSchemaName());
        result.setType(TYPE);
        result.setParameter(this.parameter);
        return result;
    }

    @Override
    public DataSource toDataSource() throws SQLException {
        return ShardingSphereDataSourceFactory.createDataSource((String)this.rootConfig.getSchemaName(), (Map)new YamlDataSourceConfigurationSwapper().swapToDataSources(this.rootConfig.getDataSources()), Collections.singletonList(ShardingRuleConfigurationSwapper.findAndConvertShardingRuleConfiguration(this.rootConfig.getRules())), null);
    }

    @Generated
    public String getParameter() {
        return this.parameter;
    }

    @Generated
    public YamlRootConfiguration getRootConfig() {
        return this.rootConfig;
    }

    @Override
    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardingSphereJDBCDataSourceConfiguration)) {
            return false;
        }
        ShardingSphereJDBCDataSourceConfiguration other = (ShardingSphereJDBCDataSourceConfiguration)o;
        String this$parameter = this.getParameter();
        String other$parameter = other.getParameter();
        return !(this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
        return result;
    }
}

