/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.config.datasource;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.config.datasource.ScalingDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.ShardingSphereJDBCDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.StandardJDBCDataSourceConfiguration;

public class ScalingDataSourceConfigurationWrap {
    private String schemaName;
    private String type;
    private String parameter;

    public ScalingDataSourceConfiguration unwrap() {
        Map classMap = DataSourceConfigurationHolder.getInstances();
        Preconditions.checkArgument((boolean)classMap.containsKey(this.type.toLowerCase()), (String)"Unsupported data source type '%s'", (Object)this.type);
        return (ScalingDataSourceConfiguration)((Class)classMap.get(this.type.toLowerCase())).getConstructor(String.class).newInstance(this.parameter);
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getParameter() {
        return this.parameter;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    private static class DataSourceConfigurationHolder {
        private static final Map<String, Class<?>> INSTANCES = new HashMap(2, 1.0f);

        private DataSourceConfigurationHolder() {
        }

        private static Map<String, Class<?>> getInstances() {
            return INSTANCES;
        }

        static {
            INSTANCES.put("JDBC".toLowerCase(), StandardJDBCDataSourceConfiguration.class);
            INSTANCES.put("ShardingSphereJDBC".toLowerCase(), ShardingSphereJDBCDataSourceConfiguration.class);
        }
    }
}

