/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.config;

import lombok.Generated;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.scaling.core.api.ScalingClusterAutoSwitchAlgorithm;
import org.apache.shardingsphere.scaling.core.api.ScalingDataConsistencyCheckAlgorithm;
import org.apache.shardingsphere.scaling.core.config.ServerConfiguration;
import org.apache.shardingsphere.scaling.core.executor.engine.ExecuteEngine;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;

public final class ScalingContext {
    private static final ScalingContext INSTANCE;
    private volatile ServerConfiguration serverConfig;
    private volatile ScalingClusterAutoSwitchAlgorithm clusterAutoSwitchAlgorithm;
    private volatile ScalingDataConsistencyCheckAlgorithm dataConsistencyCheckAlgorithm;
    private ExecuteEngine inventoryDumperExecuteEngine;
    private ExecuteEngine incrementalDumperExecuteEngine;
    private ExecuteEngine importerExecuteEngine;

    public static ScalingContext getInstance() {
        return INSTANCE;
    }

    public void init(ServerConfiguration serverConfig) {
        if (null != this.serverConfig) {
            return;
        }
        this.serverConfig = serverConfig;
        if (null != serverConfig.getClusterAutoSwitchAlgorithm()) {
            this.clusterAutoSwitchAlgorithm = (ScalingClusterAutoSwitchAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)serverConfig.getClusterAutoSwitchAlgorithm(), ScalingClusterAutoSwitchAlgorithm.class);
        }
        if (null != serverConfig.getDataConsistencyCheckAlgorithm()) {
            this.dataConsistencyCheckAlgorithm = (ScalingDataConsistencyCheckAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)serverConfig.getDataConsistencyCheckAlgorithm(), ScalingDataConsistencyCheckAlgorithm.class);
        }
        this.inventoryDumperExecuteEngine = ExecuteEngine.newFixedThreadInstance(serverConfig.getWorkerThread());
        this.incrementalDumperExecuteEngine = ExecuteEngine.newCachedThreadInstance();
        this.importerExecuteEngine = ExecuteEngine.newFixedThreadInstance(serverConfig.getWorkerThread());
    }

    @Generated
    private ScalingContext() {
    }

    @Generated
    public ServerConfiguration getServerConfig() {
        return this.serverConfig;
    }

    @Generated
    public ScalingClusterAutoSwitchAlgorithm getClusterAutoSwitchAlgorithm() {
        return this.clusterAutoSwitchAlgorithm;
    }

    @Generated
    public ScalingDataConsistencyCheckAlgorithm getDataConsistencyCheckAlgorithm() {
        return this.dataConsistencyCheckAlgorithm;
    }

    @Generated
    public ExecuteEngine getInventoryDumperExecuteEngine() {
        return this.inventoryDumperExecuteEngine;
    }

    @Generated
    public ExecuteEngine getIncrementalDumperExecuteEngine() {
        return this.incrementalDumperExecuteEngine;
    }

    @Generated
    public ExecuteEngine getImporterExecuteEngine() {
        return this.importerExecuteEngine;
    }

    static {
        ShardingSphereServiceLoader.register(ScalingClusterAutoSwitchAlgorithm.class);
        ShardingSphereServiceLoader.register(ScalingDataConsistencyCheckAlgorithm.class);
        INSTANCE = new ScalingContext();
    }
}

