/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.common.record;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.record.Column;
import org.apache.shardingsphere.scaling.core.common.record.DataRecord;

public final class RecordUtil {
    public static List<Column> extractPrimaryColumns(DataRecord dataRecord) {
        ArrayList<Column> result = new ArrayList<Column>(dataRecord.getColumns().size());
        for (Column each : dataRecord.getColumns()) {
            if (!each.isPrimaryKey()) continue;
            result.add(each);
        }
        return result;
    }

    public static List<Column> extractConditionColumns(DataRecord dataRecord, Set<String> shardingColumns) {
        ArrayList<Column> result = new ArrayList<Column>(dataRecord.getColumns().size());
        for (Column each : dataRecord.getColumns()) {
            if (!each.isPrimaryKey() && !shardingColumns.contains(each.getName())) continue;
            result.add(each);
        }
        return result;
    }

    public static List<Column> extractUpdatedColumns(DataRecord dataRecord) {
        ArrayList<Column> result = new ArrayList<Column>(dataRecord.getColumns().size());
        for (Column each : dataRecord.getColumns()) {
            if (!each.isUpdated()) continue;
            result.add(each);
        }
        return result;
    }

    @Generated
    private RecordUtil() {
    }
}

