/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.common.record;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.record.Column;
import org.apache.shardingsphere.scaling.core.common.record.Record;
import org.apache.shardingsphere.scaling.core.job.position.ScalingPosition;

public final class DataRecord
extends Record {
    private final List<Column> columns;
    private final List<Object> primaryKeyValue = new LinkedList<Object>();
    private final List<Object> oldPrimaryKeyValues = new ArrayList<Object>();
    private String type;
    private String tableName;

    public DataRecord(ScalingPosition<?> position, int columnCount) {
        super(position);
        this.columns = new ArrayList<Column>(columnCount);
    }

    public void addColumn(Column data) {
        this.columns.add(data);
        if (data.isPrimaryKey()) {
            this.primaryKeyValue.add(data.getValue());
            this.oldPrimaryKeyValues.add(data.getOldValue());
        }
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Column getColumn(int index) {
        return this.columns.get(index);
    }

    public Key getKey() {
        return new Key(this.tableName, this.primaryKeyValue);
    }

    public Key getOldKey() {
        return new Key(this.tableName, this.oldPrimaryKeyValues);
    }

    @Generated
    public List<Column> getColumns() {
        return this.columns;
    }

    @Generated
    public List<Object> getPrimaryKeyValue() {
        return this.primaryKeyValue;
    }

    @Generated
    public List<Object> getOldPrimaryKeyValues() {
        return this.oldPrimaryKeyValues;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataRecord)) {
            return false;
        }
        DataRecord other = (DataRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Object> this$primaryKeyValue = this.getPrimaryKeyValue();
        List<Object> other$primaryKeyValue = other.getPrimaryKeyValue();
        if (this$primaryKeyValue == null ? other$primaryKeyValue != null : !((Object)this$primaryKeyValue).equals(other$primaryKeyValue)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Object> $primaryKeyValue = this.getPrimaryKeyValue();
        result = result * 59 + ($primaryKeyValue == null ? 43 : ((Object)$primaryKeyValue).hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DataRecord(columns=" + this.getColumns() + ", primaryKeyValue=" + this.getPrimaryKeyValue() + ", oldPrimaryKeyValues=" + this.getOldPrimaryKeyValues() + ", type=" + this.getType() + ", tableName=" + this.getTableName() + ")";
    }

    public static class Key {
        private final String tableName;
        private final List<Object> primaryKeyValues;

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tableName = this.tableName;
            String other$tableName = other.tableName;
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            List<Object> this$primaryKeyValues = this.primaryKeyValues;
            List<Object> other$primaryKeyValues = other.primaryKeyValues;
            return !(this$primaryKeyValues == null ? other$primaryKeyValues != null : !((Object)this$primaryKeyValues).equals(other$primaryKeyValues));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tableName = this.tableName;
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            List<Object> $primaryKeyValues = this.primaryKeyValues;
            result = result * 59 + ($primaryKeyValues == null ? 43 : ((Object)$primaryKeyValues).hashCode());
            return result;
        }

        @Generated
        public Key(String tableName, List<Object> primaryKeyValues) {
            this.tableName = tableName;
            this.primaryKeyValues = primaryKeyValues;
        }
    }
}

