/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.common.datasource;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.TableMetaDataLoaderEngine;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.TableMetaDataLoaderMaterial;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;

public final class MetaDataManager {
    private final DataSource dataSource;
    private final Map<String, TableMetaData> tableMetaDataMap = new HashMap<String, TableMetaData>();

    public TableMetaData getTableMetaData(String tableName, DatabaseType databaseType) {
        if (!this.tableMetaDataMap.containsKey(tableName)) {
            try {
                TableMetaDataLoaderEngine.load(Collections.singletonList(new TableMetaDataLoaderMaterial(Collections.singletonList(tableName), this.dataSource)), (DatabaseType)databaseType).stream().findFirst().ifPresent(tableMetaData -> this.tableMetaDataMap.put(tableName, (TableMetaData)tableMetaData));
            }
            catch (SQLException ex) {
                throw new RuntimeException(String.format("Load metaData for table %s failed", tableName), ex);
            }
        }
        return this.tableMetaDataMap.get(tableName);
    }

    @Generated
    public MetaDataManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

