/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.common.datasource;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public final class JdbcUri {
    private final URI jdbcUri;

    public JdbcUri(String jdbcUrl) {
        this.jdbcUri = URI.create(jdbcUrl.substring(5));
    }

    public String getScheme() {
        return this.jdbcUri.getScheme();
    }

    public String getHostname() {
        return this.jdbcUri.getHost();
    }

    public int getPort() {
        return -1 == this.jdbcUri.getPort() ? 3306 : this.jdbcUri.getPort();
    }

    public String getHost() {
        return String.format("%s:%d", this.getHostname(), this.getPort());
    }

    public String getDatabase() {
        return null == this.jdbcUri.getPath() ? "" : this.jdbcUri.getPath().replaceFirst("/", "");
    }

    public Map<String, String> getParameters() {
        String[] parameters;
        HashMap<String, String> result = new HashMap<String, String>();
        if (Strings.isNullOrEmpty((String)this.jdbcUri.getQuery())) {
            return result;
        }
        for (String each : parameters = this.jdbcUri.getQuery().split("&")) {
            String[] args = each.split("=");
            result.put(args[0], 1 == args.length ? null : args[1]);
        }
        return result;
    }
}

