/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.common.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import lombok.Generated;

public final class DataSourceWrapper
implements DataSource,
AutoCloseable {
    private final DataSource dataSource;

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.dataSource.getConnection(username, password);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public void close() throws SQLException {
        if (null == this.dataSource) {
            return;
        }
        if (this.dataSource instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.dataSource)).close();
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SQLException("data source close failed.", ex);
            }
        }
    }

    @Generated
    public DataSourceWrapper(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

